/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.security_scheme.oauth2.flow;

import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class OAuthFlow {
    @CheckForNull
    private String refreshUrl;
    @Nonnull
    @NonNull
    private Map<String, String> scopes;

    public static OAuthFlowBuilder builder() {
        return new OAuthFlowBuilder();
    }

    @CheckForNull
    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    @Nonnull
    @NonNull
    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public void setRefreshUrl(@CheckForNull String refreshUrl) {
        this.refreshUrl = refreshUrl;
    }

    public void setScopes(@Nonnull @NonNull Map<String, String> scopes) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthFlow)) {
            return false;
        }
        OAuthFlow other = (OAuthFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$refreshUrl = this.getRefreshUrl();
        String other$refreshUrl = other.getRefreshUrl();
        if (this$refreshUrl == null ? other$refreshUrl != null : !this$refreshUrl.equals(other$refreshUrl)) {
            return false;
        }
        Map<String, String> this$scopes = this.getScopes();
        Map<String, String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthFlow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $refreshUrl = this.getRefreshUrl();
        result = result * 59 + ($refreshUrl == null ? 43 : $refreshUrl.hashCode());
        Map<String, String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    public String toString() {
        return "OAuthFlow(refreshUrl=" + this.getRefreshUrl() + ", scopes=" + this.getScopes() + ")";
    }

    public OAuthFlow() {
    }

    public OAuthFlow(@CheckForNull String refreshUrl, @Nonnull @NonNull Map<String, String> scopes) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        this.refreshUrl = refreshUrl;
        this.scopes = scopes;
    }

    public static class OAuthFlowBuilder {
        private String refreshUrl;
        private Map<String, String> scopes;

        OAuthFlowBuilder() {
        }

        public OAuthFlowBuilder refreshUrl(@CheckForNull String refreshUrl) {
            this.refreshUrl = refreshUrl;
            return this;
        }

        public OAuthFlowBuilder scopes(@Nonnull @NonNull Map<String, String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public OAuthFlow build() {
            return new OAuthFlow(this.refreshUrl, this.scopes);
        }

        public String toString() {
            return "OAuthFlow.OAuthFlowBuilder(refreshUrl=" + this.refreshUrl + ", scopes=" + this.scopes + ")";
        }
    }
}

