/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.binding.channel.ibmmq;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.Max;
import org.jetbrains.annotations.Nullable;

public class IBMMQChannelTopicProperties {
    @Max(value=10240L, message="Maximum length of topic string must be lower or equals to 10240")
    @JsonProperty(value="string")
    @JsonPropertyDescription(value="The value of the IBM MQ topic string to be used.")
    @Nullable
    private @Max(value=10240L, message="Maximum length of topic string must be lower or equals to 10240") @Nullable String string;
    @Max(value=48L, message="Maximum length of topic name must be lower or equals to 48")
    @JsonProperty(value="objectName")
    @JsonPropertyDescription(value="The name of the IBM MQ topic object.")
    @Nullable
    private @Max(value=48L, message="Maximum length of topic name must be lower or equals to 48") @Nullable String objectName;
    @JsonProperty(value="durablePermitted", defaultValue="true")
    @JsonPropertyDescription(value="Defines if the subscription may be durable.")
    @Nullable
    private Boolean durablePermitted;
    @JsonProperty(value="lastMsgRetained", defaultValue="false")
    @JsonPropertyDescription(value="Defines if the last message published will be made available to new subscriptions.")
    @Nullable
    private Boolean lastMsgRetained;

    private static Boolean $default$durablePermitted() {
        return true;
    }

    private static Boolean $default$lastMsgRetained() {
        return false;
    }

    public static IBMMQChannelTopicPropertiesBuilder builder() {
        return new IBMMQChannelTopicPropertiesBuilder();
    }

    @Nullable
    public String getString() {
        return this.string;
    }

    @Nullable
    public String getObjectName() {
        return this.objectName;
    }

    @Nullable
    public Boolean getDurablePermitted() {
        return this.durablePermitted;
    }

    @Nullable
    public Boolean getLastMsgRetained() {
        return this.lastMsgRetained;
    }

    @JsonProperty(value="string")
    public void setString(@Nullable String string) {
        this.string = string;
    }

    @JsonProperty(value="objectName")
    public void setObjectName(@Nullable String objectName) {
        this.objectName = objectName;
    }

    @JsonProperty(value="durablePermitted", defaultValue="true")
    public void setDurablePermitted(@Nullable Boolean durablePermitted) {
        this.durablePermitted = durablePermitted;
    }

    @JsonProperty(value="lastMsgRetained", defaultValue="false")
    public void setLastMsgRetained(@Nullable Boolean lastMsgRetained) {
        this.lastMsgRetained = lastMsgRetained;
    }

    public String toString() {
        return "IBMMQChannelTopicProperties(string=" + this.getString() + ", objectName=" + this.getObjectName() + ", durablePermitted=" + this.getDurablePermitted() + ", lastMsgRetained=" + this.getLastMsgRetained() + ")";
    }

    public IBMMQChannelTopicProperties() {
        this.durablePermitted = IBMMQChannelTopicProperties.$default$durablePermitted();
        this.lastMsgRetained = IBMMQChannelTopicProperties.$default$lastMsgRetained();
    }

    public IBMMQChannelTopicProperties(@Nullable String string, @Nullable String objectName, @Nullable Boolean durablePermitted, @Nullable Boolean lastMsgRetained) {
        this.string = string;
        this.objectName = objectName;
        this.durablePermitted = durablePermitted;
        this.lastMsgRetained = lastMsgRetained;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IBMMQChannelTopicProperties)) {
            return false;
        }
        IBMMQChannelTopicProperties other = (IBMMQChannelTopicProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$string = this.getString();
        String other$string = other.getString();
        if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        Boolean this$durablePermitted = this.getDurablePermitted();
        Boolean other$durablePermitted = other.getDurablePermitted();
        if (this$durablePermitted == null ? other$durablePermitted != null : !((Object)this$durablePermitted).equals(other$durablePermitted)) {
            return false;
        }
        Boolean this$lastMsgRetained = this.getLastMsgRetained();
        Boolean other$lastMsgRetained = other.getLastMsgRetained();
        return !(this$lastMsgRetained == null ? other$lastMsgRetained != null : !((Object)this$lastMsgRetained).equals(other$lastMsgRetained));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IBMMQChannelTopicProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        Boolean $durablePermitted = this.getDurablePermitted();
        result = result * 59 + ($durablePermitted == null ? 43 : ((Object)$durablePermitted).hashCode());
        Boolean $lastMsgRetained = this.getLastMsgRetained();
        result = result * 59 + ($lastMsgRetained == null ? 43 : ((Object)$lastMsgRetained).hashCode());
        return result;
    }

    public static class IBMMQChannelTopicPropertiesBuilder {
        private String string;
        private String objectName;
        private boolean durablePermitted$set;
        private Boolean durablePermitted$value;
        private boolean lastMsgRetained$set;
        private Boolean lastMsgRetained$value;

        IBMMQChannelTopicPropertiesBuilder() {
        }

        @JsonProperty(value="string")
        public IBMMQChannelTopicPropertiesBuilder string(@Nullable String string) {
            this.string = string;
            return this;
        }

        @JsonProperty(value="objectName")
        public IBMMQChannelTopicPropertiesBuilder objectName(@Nullable String objectName) {
            this.objectName = objectName;
            return this;
        }

        @JsonProperty(value="durablePermitted", defaultValue="true")
        public IBMMQChannelTopicPropertiesBuilder durablePermitted(@Nullable Boolean durablePermitted) {
            this.durablePermitted$value = durablePermitted;
            this.durablePermitted$set = true;
            return this;
        }

        @JsonProperty(value="lastMsgRetained", defaultValue="false")
        public IBMMQChannelTopicPropertiesBuilder lastMsgRetained(@Nullable Boolean lastMsgRetained) {
            this.lastMsgRetained$value = lastMsgRetained;
            this.lastMsgRetained$set = true;
            return this;
        }

        public IBMMQChannelTopicProperties build() {
            Boolean durablePermitted$value = this.durablePermitted$value;
            if (!this.durablePermitted$set) {
                durablePermitted$value = IBMMQChannelTopicProperties.$default$durablePermitted();
            }
            Boolean lastMsgRetained$value = this.lastMsgRetained$value;
            if (!this.lastMsgRetained$set) {
                lastMsgRetained$value = IBMMQChannelTopicProperties.$default$lastMsgRetained();
            }
            return new IBMMQChannelTopicProperties(this.string, this.objectName, durablePermitted$value, lastMsgRetained$value);
        }

        public String toString() {
            return "IBMMQChannelTopicProperties.IBMMQChannelTopicPropertiesBuilder(string=" + this.string + ", objectName=" + this.objectName + ", durablePermitted$value=" + this.durablePermitted$value + ", lastMsgRetained$value=" + this.lastMsgRetained$value + ")";
        }
    }
}

