/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.binding.operation.amqp;

import com.asyncapi.v3.binding.operation.OperationBinding;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes AMQP 0-9-1 operation binding.")
public class AMQPOperationBinding
extends OperationBinding {
    @Min(value=0L, message="TTL (Time-To-Live) for the message must be greater than or equal to zero")
    @JsonProperty(value="expiration")
    @JsonPropertyDescription(value="TTL (Time-To-Live) for the message. It MUST be greater than or equal to zero.")
    @Nullable
    private @Min(value=0L, message="TTL (Time-To-Live) for the message must be greater than or equal to zero") @Nullable Integer expiration;
    @JsonProperty(value="userId")
    @JsonPropertyDescription(value="Identifies the user who has sent the message.")
    @Nullable
    private String userId;
    @JsonProperty(value="cc")
    @JsonPropertyDescription(value="The routing keys the message should be routed to at the time of publishing.")
    @Nullable
    private List<String> cc;
    @JsonProperty(value="priority")
    @JsonPropertyDescription(value="A priority for the message.")
    @Nullable
    private Integer priority;
    @Min(value=1L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)")
    @Max(value=2L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)")
    @JsonProperty(value="deliveryMode")
    @JsonPropertyDescription(value="Delivery mode of the message. Its value MUST be either 1 (transient) or 2 (persistent).")
    @Nullable
    private @Min(value=1L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)") @Max(value=2L, message="Delivery mode of the message must be either 1 (transient) or 2 (persistent)") @Nullable Integer deliveryMode;
    @JsonProperty(value="mandatory")
    @JsonPropertyDescription(value="Whether the message is mandatory or not.")
    @Nullable
    private Boolean mandatory;
    @JsonProperty(value="bcc")
    @JsonPropertyDescription(value="Like cc but consumers will not receive this information.")
    @Nullable
    private List<String> bcc;
    @JsonProperty(value="replyTo")
    @JsonPropertyDescription(value="Name of the queue where the consumer should send the response.")
    @Nullable
    private String replyTo;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Whether the message should include a timestamp or not.")
    @Nullable
    private Boolean timestamp;
    @JsonProperty(value="ack")
    @JsonPropertyDescription(value="Whether the consumer should ack the message or not.")
    @Nullable
    private Boolean ack;
    @JsonProperty(value="bindingVersion")
    @JsonPropertyDescription(value="The version of this binding.")
    @Nullable
    private String bindingVersion;

    private static String $default$bindingVersion() {
        return "0.2.0";
    }

    public static AMQPOperationBindingBuilder builder() {
        return new AMQPOperationBindingBuilder();
    }

    @Nullable
    public Integer getExpiration() {
        return this.expiration;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public List<String> getCc() {
        return this.cc;
    }

    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    @Nullable
    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    @Nullable
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @Nullable
    public List<String> getBcc() {
        return this.bcc;
    }

    @Nullable
    public String getReplyTo() {
        return this.replyTo;
    }

    @Nullable
    public Boolean getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Boolean getAck() {
        return this.ack;
    }

    @Nullable
    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="expiration")
    public void setExpiration(@Nullable Integer expiration) {
        this.expiration = expiration;
    }

    @JsonProperty(value="userId")
    public void setUserId(@Nullable String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="cc")
    public void setCc(@Nullable List<String> cc) {
        this.cc = cc;
    }

    @JsonProperty(value="priority")
    public void setPriority(@Nullable Integer priority) {
        this.priority = priority;
    }

    @JsonProperty(value="deliveryMode")
    public void setDeliveryMode(@Nullable Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @JsonProperty(value="mandatory")
    public void setMandatory(@Nullable Boolean mandatory) {
        this.mandatory = mandatory;
    }

    @JsonProperty(value="bcc")
    public void setBcc(@Nullable List<String> bcc) {
        this.bcc = bcc;
    }

    @JsonProperty(value="replyTo")
    public void setReplyTo(@Nullable String replyTo) {
        this.replyTo = replyTo;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(@Nullable Boolean timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="ack")
    public void setAck(@Nullable Boolean ack) {
        this.ack = ack;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(@Nullable String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "AMQPOperationBinding(expiration=" + this.getExpiration() + ", userId=" + this.getUserId() + ", cc=" + this.getCc() + ", priority=" + this.getPriority() + ", deliveryMode=" + this.getDeliveryMode() + ", mandatory=" + this.getMandatory() + ", bcc=" + this.getBcc() + ", replyTo=" + this.getReplyTo() + ", timestamp=" + this.getTimestamp() + ", ack=" + this.getAck() + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public AMQPOperationBinding() {
        this.bindingVersion = AMQPOperationBinding.$default$bindingVersion();
    }

    public AMQPOperationBinding(@Nullable Integer expiration, @Nullable String userId, @Nullable List<String> cc, @Nullable Integer priority, @Nullable Integer deliveryMode, @Nullable Boolean mandatory, @Nullable List<String> bcc, @Nullable String replyTo, @Nullable Boolean timestamp, @Nullable Boolean ack, @Nullable String bindingVersion) {
        this.expiration = expiration;
        this.userId = userId;
        this.cc = cc;
        this.priority = priority;
        this.deliveryMode = deliveryMode;
        this.mandatory = mandatory;
        this.bcc = bcc;
        this.replyTo = replyTo;
        this.timestamp = timestamp;
        this.ack = ack;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AMQPOperationBinding)) {
            return false;
        }
        AMQPOperationBinding other = (AMQPOperationBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$expiration = this.getExpiration();
        Integer other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        List<String> this$cc = this.getCc();
        List<String> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        Integer this$deliveryMode = this.getDeliveryMode();
        Integer other$deliveryMode = other.getDeliveryMode();
        if (this$deliveryMode == null ? other$deliveryMode != null : !((Object)this$deliveryMode).equals(other$deliveryMode)) {
            return false;
        }
        Boolean this$mandatory = this.getMandatory();
        Boolean other$mandatory = other.getMandatory();
        if (this$mandatory == null ? other$mandatory != null : !((Object)this$mandatory).equals(other$mandatory)) {
            return false;
        }
        List<String> this$bcc = this.getBcc();
        List<String> other$bcc = other.getBcc();
        if (this$bcc == null ? other$bcc != null : !((Object)this$bcc).equals(other$bcc)) {
            return false;
        }
        String this$replyTo = this.getReplyTo();
        String other$replyTo = other.getReplyTo();
        if (this$replyTo == null ? other$replyTo != null : !this$replyTo.equals(other$replyTo)) {
            return false;
        }
        Boolean this$timestamp = this.getTimestamp();
        Boolean other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Boolean this$ack = this.getAck();
        Boolean other$ack = other.getAck();
        if (this$ack == null ? other$ack != null : !((Object)this$ack).equals(other$ack)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AMQPOperationBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        List<String> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        Integer $deliveryMode = this.getDeliveryMode();
        result = result * 59 + ($deliveryMode == null ? 43 : ((Object)$deliveryMode).hashCode());
        Boolean $mandatory = this.getMandatory();
        result = result * 59 + ($mandatory == null ? 43 : ((Object)$mandatory).hashCode());
        List<String> $bcc = this.getBcc();
        result = result * 59 + ($bcc == null ? 43 : ((Object)$bcc).hashCode());
        String $replyTo = this.getReplyTo();
        result = result * 59 + ($replyTo == null ? 43 : $replyTo.hashCode());
        Boolean $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Boolean $ack = this.getAck();
        result = result * 59 + ($ack == null ? 43 : ((Object)$ack).hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class AMQPOperationBindingBuilder {
        private Integer expiration;
        private String userId;
        private List<String> cc;
        private Integer priority;
        private Integer deliveryMode;
        private Boolean mandatory;
        private List<String> bcc;
        private String replyTo;
        private Boolean timestamp;
        private Boolean ack;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        AMQPOperationBindingBuilder() {
        }

        @JsonProperty(value="expiration")
        public AMQPOperationBindingBuilder expiration(@Nullable Integer expiration) {
            this.expiration = expiration;
            return this;
        }

        @JsonProperty(value="userId")
        public AMQPOperationBindingBuilder userId(@Nullable String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="cc")
        public AMQPOperationBindingBuilder cc(@Nullable List<String> cc) {
            this.cc = cc;
            return this;
        }

        @JsonProperty(value="priority")
        public AMQPOperationBindingBuilder priority(@Nullable Integer priority) {
            this.priority = priority;
            return this;
        }

        @JsonProperty(value="deliveryMode")
        public AMQPOperationBindingBuilder deliveryMode(@Nullable Integer deliveryMode) {
            this.deliveryMode = deliveryMode;
            return this;
        }

        @JsonProperty(value="mandatory")
        public AMQPOperationBindingBuilder mandatory(@Nullable Boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        @JsonProperty(value="bcc")
        public AMQPOperationBindingBuilder bcc(@Nullable List<String> bcc) {
            this.bcc = bcc;
            return this;
        }

        @JsonProperty(value="replyTo")
        public AMQPOperationBindingBuilder replyTo(@Nullable String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        @JsonProperty(value="timestamp")
        public AMQPOperationBindingBuilder timestamp(@Nullable Boolean timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="ack")
        public AMQPOperationBindingBuilder ack(@Nullable Boolean ack) {
            this.ack = ack;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public AMQPOperationBindingBuilder bindingVersion(@Nullable String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public AMQPOperationBinding build() {
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = AMQPOperationBinding.$default$bindingVersion();
            }
            return new AMQPOperationBinding(this.expiration, this.userId, this.cc, this.priority, this.deliveryMode, this.mandatory, this.bcc, this.replyTo, this.timestamp, this.ack, bindingVersion$value);
        }

        public String toString() {
            return "AMQPOperationBinding.AMQPOperationBindingBuilder(expiration=" + this.expiration + ", userId=" + this.userId + ", cc=" + this.cc + ", priority=" + this.priority + ", deliveryMode=" + this.deliveryMode + ", mandatory=" + this.mandatory + ", bcc=" + this.bcc + ", replyTo=" + this.replyTo + ", timestamp=" + this.timestamp + ", ack=" + this.ack + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

