/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.binding.operation.http;

import com.asyncapi.v3.binding.operation.OperationBinding;
import com.asyncapi.v3.binding.operation.http.HTTPOperationMethod;
import com.asyncapi.v3.binding.operation.http.HTTPOperationType;
import com.asyncapi.v3.schema.AsyncAPISchema;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTTPOperationBinding
extends OperationBinding {
    @NotNull
    @JsonProperty(value="type", required=true)
    @JsonPropertyDescription(value="Type of operation. Its value MUST be either request or response.")
    @org.jetbrains.annotations.NotNull
    private HTTPOperationType type;
    @JsonProperty(value="method")
    @JsonPropertyDescription(value="When type is request, this is the HTTP method, otherwise it MUST be ignored. Its value MUST be one of GET, POST, PUT, PATCH, DELETE, HEAD, OPTIONS, CONNECT, and TRACE.")
    @Nullable
    private HTTPOperationMethod method;
    @JsonProperty(value="query")
    @JsonPropertyDescription(value="A Schema object containing the definitions for each query parameter. This schema MUST be of type object and have a properties key.")
    @Nullable
    private AsyncAPISchema query;
    @JsonProperty(value="bindingVersion")
    @JsonPropertyDescription(value="The version of this binding.")
    @Nullable
    private String bindingVersion;

    private static HTTPOperationType $default$type() {
        return HTTPOperationType.REQUEST;
    }

    private static String $default$bindingVersion() {
        return "0.1.0";
    }

    public static HTTPOperationBindingBuilder builder() {
        return new HTTPOperationBindingBuilder();
    }

    @org.jetbrains.annotations.NotNull
    public HTTPOperationType getType() {
        return this.type;
    }

    @Nullable
    public HTTPOperationMethod getMethod() {
        return this.method;
    }

    @Nullable
    public AsyncAPISchema getQuery() {
        return this.query;
    }

    @Nullable
    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="type", required=true)
    public void setType(@org.jetbrains.annotations.NotNull HTTPOperationType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="method")
    public void setMethod(@Nullable HTTPOperationMethod method) {
        this.method = method;
    }

    @JsonProperty(value="query")
    public void setQuery(@Nullable AsyncAPISchema query) {
        this.query = query;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(@Nullable String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "HTTPOperationBinding(type=" + (Object)((Object)this.getType()) + ", method=" + (Object)((Object)this.getMethod()) + ", query=" + this.getQuery() + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public HTTPOperationBinding() {
        this.type = HTTPOperationBinding.$default$type();
        this.bindingVersion = HTTPOperationBinding.$default$bindingVersion();
    }

    public HTTPOperationBinding(@org.jetbrains.annotations.NotNull HTTPOperationType type, @Nullable HTTPOperationMethod method, @Nullable AsyncAPISchema query, @Nullable String bindingVersion) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.method = method;
        this.query = query;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HTTPOperationBinding)) {
            return false;
        }
        HTTPOperationBinding other = (HTTPOperationBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPOperationType this$type = this.getType();
        HTTPOperationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        HTTPOperationMethod this$method = this.getMethod();
        HTTPOperationMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        AsyncAPISchema this$query = this.getQuery();
        AsyncAPISchema other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HTTPOperationBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HTTPOperationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        HTTPOperationMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        AsyncAPISchema $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class HTTPOperationBindingBuilder {
        private boolean type$set;
        private HTTPOperationType type$value;
        private HTTPOperationMethod method;
        private AsyncAPISchema query;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        HTTPOperationBindingBuilder() {
        }

        @JsonProperty(value="type", required=true)
        public HTTPOperationBindingBuilder type(@org.jetbrains.annotations.NotNull HTTPOperationType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @JsonProperty(value="method")
        public HTTPOperationBindingBuilder method(@Nullable HTTPOperationMethod method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="query")
        public HTTPOperationBindingBuilder query(@Nullable AsyncAPISchema query) {
            this.query = query;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public HTTPOperationBindingBuilder bindingVersion(@Nullable String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public HTTPOperationBinding build() {
            HTTPOperationType type$value = this.type$value;
            if (!this.type$set) {
                type$value = HTTPOperationBinding.$default$type();
            }
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = HTTPOperationBinding.$default$bindingVersion();
            }
            return new HTTPOperationBinding(type$value, this.method, this.query, bindingVersion$value);
        }

        public String toString() {
            return "HTTPOperationBinding.HTTPOperationBindingBuilder(type$value=" + (Object)((Object)this.type$value) + ", method=" + (Object)((Object)this.method) + ", query=" + this.query + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

