/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.jackson.schema.openapi;

import com.asyncapi.v3.schema.openapi.v3._0_0.OpenAPISchema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class OpenAPISchemaAdditionalPropertiesDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        return this.chooseKnownPojo(node, objectCodec);
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            if (jsonNode.isBoolean()) {
                Boolean bl = jsonNode.asBoolean();
                return bl;
            }
            Object object = jsonParser.readValueAs(OpenAPISchema.class);
            return object;
        }
    }
}

