/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.schema;

import com.asyncapi.v3.ExtendableObject;
import com.asyncapi.v3._0_0.jackson.model.ExternalDocumentationDeserializer;
import com.asyncapi.v3.jackson.schema.AsyncAPISchemaAdditionalPropertiesDeserializer;
import com.asyncapi.v3.jackson.schema.AsyncAPISchemaAnyValueDeserializer;
import com.asyncapi.v3.jackson.schema.AsyncAPISchemaItemsDeserializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

public class AsyncAPISchema
extends ExtendableObject {
    @JsonProperty(value="$id")
    @JsonPropertyDescription(value="JSON Schema ID.")
    @Nullable
    public String id;
    @JsonProperty(value="$schema")
    @JsonPropertyDescription(value="JSON Schema to use for validation.")
    @Nullable
    public String schema;
    @JsonProperty(value="$ref")
    @JsonPropertyDescription(value="Reference to JSON Schema definition.")
    @Nullable
    private String ref;
    @JsonProperty(value="$comment")
    @JsonPropertyDescription(value="JSON Schema comment.")
    @Nullable
    private String comment;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="JSON Schema type.")
    @Nullable
    public Object type;
    @JsonProperty(value="enum")
    @JsonPropertyDescription(value="JSON Schema enum values.")
    @Nullable
    public List<Object> enumValue;
    @JsonProperty(value="const")
    @JsonPropertyDescription(value="JSON Schema const value")
    @JsonDeserialize(using=AsyncAPISchemaAnyValueDeserializer.class)
    @Nullable
    public Object constValue;
    @Min(value=1L, message="The value of \"multipleOf\" MUST be a number, strictly greater than 0.")
    @JsonProperty(value="multipleOf")
    @Nullable
    public @Min(value=1L, message="The value of \"multipleOf\" MUST be a number, strictly greater than 0.") @Nullable Number multipleOf;
    @JsonProperty(value="maximum")
    @Nullable
    public BigDecimal maximum;
    @JsonProperty(value="exclusiveMaximum")
    @Nullable
    public BigDecimal exclusiveMaximum;
    @JsonProperty(value="minimum")
    @Nullable
    public BigDecimal minimum;
    @JsonProperty(value="exclusiveMinimum")
    @Nullable
    public BigDecimal exclusiveMinimum;
    @Min(value=0L, message="The value of \"maxLength\" MUST be a non-negative integer.")
    @JsonProperty(value="maxLength")
    @Nullable
    public @Min(value=0L, message="The value of \"maxLength\" MUST be a non-negative integer.") @Nullable Integer maxLength;
    @Min(value=0L, message="The value of \"minLength\" MUST be a non-negative integer.")
    @JsonProperty(value="minLength")
    @Nullable
    public @Min(value=0L, message="The value of \"minLength\" MUST be a non-negative integer.") @Nullable Integer minLength;
    @JsonProperty(value="pattern")
    @Nullable
    public String pattern;
    @JsonProperty(value="items")
    @JsonDeserialize(using=AsyncAPISchemaItemsDeserializer.class)
    @Nullable
    public Object items;
    @JsonProperty(value="additionalItems")
    @Nullable
    public AsyncAPISchema additionalItems;
    @Min(value=0L, message="The value of \"maxItems\" MUST be a non-negative integer.")
    @JsonProperty(value="maxItems")
    @Nullable
    public @Min(value=0L, message="The value of \"maxItems\" MUST be a non-negative integer.") @Nullable Integer maxItems;
    @JsonProperty(value="minItems")
    @Nullable
    public Integer minItems;
    @JsonProperty(value="uniqueItems")
    @Nullable
    public Boolean uniqueItems;
    @JsonProperty(value="contains")
    @Nullable
    public AsyncAPISchema contains;
    @Min(value=0L, message="The value of \"maxProperties\" MUST be a non-negative integer.")
    @JsonProperty(value="maxProperties")
    @Nullable
    public @Min(value=0L, message="The value of \"maxProperties\" MUST be a non-negative integer.") @Nullable Integer maxProperties;
    @Min(value=0L, message="The value of \"minProperties\" MUST be a non-negative integer.")
    @JsonProperty(value="minProperties")
    @Nullable
    public @Min(value=0L, message="The value of \"minProperties\" MUST be a non-negative integer.") @Nullable Integer minProperties;
    @JsonProperty(value="required")
    @Nullable
    public List<String> required;
    @JsonProperty(value="properties")
    @JsonDeserialize(contentUsing=AsyncAPISchemaAdditionalPropertiesDeserializer.class)
    @Nullable
    public Map<String, Object> properties;
    @JsonProperty(value="patternProperties")
    @Nullable
    public Map<String, AsyncAPISchema> patternProperties;
    @JsonProperty(value="additionalProperties")
    @JsonDeserialize(using=AsyncAPISchemaAdditionalPropertiesDeserializer.class)
    @Nullable
    public Object additionalProperties;
    @JsonProperty(value="dependencies")
    @Nullable
    public Object dependencies;
    @JsonProperty(value="propertyNames")
    @Nullable
    public AsyncAPISchema propertyNames;
    @JsonProperty(value="if")
    @Nullable
    public AsyncAPISchema ifValue;
    @JsonProperty(value="then")
    @Nullable
    public AsyncAPISchema thenValue;
    @JsonProperty(value="else")
    @Nullable
    public AsyncAPISchema elseValue;
    @JsonProperty(value="allOf")
    @Nullable
    public List<AsyncAPISchema> allOf;
    @JsonProperty(value="anyOf")
    @Nullable
    public List<AsyncAPISchema> anyOf;
    @JsonProperty(value="oneOf")
    @Nullable
    public List<AsyncAPISchema> oneOf;
    @JsonProperty(value="not")
    @Nullable
    public AsyncAPISchema not;
    @JsonProperty(value="format")
    @Nullable
    public String format;
    @JsonProperty(value="contentEncoding")
    @Nullable
    private String contentEncoding;
    @JsonProperty(value="contentMediaType")
    @Nullable
    private String contentMediaType;
    @JsonProperty(value="definitions")
    @Nullable
    private Map<String, AsyncAPISchema> definitions;
    @JsonProperty(value="title")
    @Nullable
    public String title;
    @JsonProperty(value="description")
    @Nullable
    public String description;
    @JsonProperty(value="default")
    @JsonDeserialize(using=AsyncAPISchemaAnyValueDeserializer.class)
    @Nullable
    public Object defaultValue;
    @JsonProperty(value="readOnly")
    @Nullable
    public Boolean readOnly;
    @JsonProperty(value="writeOnly")
    @Nullable
    public Boolean writeOnly;
    @JsonProperty(value="examples")
    @JsonDeserialize(contentUsing=AsyncAPISchemaAnyValueDeserializer.class)
    @Nullable
    public List<Object> examples;
    @JsonProperty(value="discriminator")
    @Nullable
    private String discriminator;
    @JsonProperty(value="externalDocs")
    @JsonDeserialize(using=ExternalDocumentationDeserializer.class)
    @Nullable
    private Object externalDocs;
    @JsonProperty(value="deprecated")
    @Nullable
    private Boolean deprecated;

    public static AsyncAPISchemaBuilder builder() {
        return new AsyncAPISchemaBuilder();
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public Object getType() {
        return this.type;
    }

    @Nullable
    public List<Object> getEnumValue() {
        return this.enumValue;
    }

    @Nullable
    public Object getConstValue() {
        return this.constValue;
    }

    @Nullable
    public Number getMultipleOf() {
        return this.multipleOf;
    }

    @Nullable
    public BigDecimal getMaximum() {
        return this.maximum;
    }

    @Nullable
    public BigDecimal getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Nullable
    public BigDecimal getMinimum() {
        return this.minimum;
    }

    @Nullable
    public BigDecimal getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Nullable
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    public Integer getMinLength() {
        return this.minLength;
    }

    @Nullable
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public Object getItems() {
        return this.items;
    }

    @Nullable
    public AsyncAPISchema getAdditionalItems() {
        return this.additionalItems;
    }

    @Nullable
    public Integer getMaxItems() {
        return this.maxItems;
    }

    @Nullable
    public Integer getMinItems() {
        return this.minItems;
    }

    @Nullable
    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Nullable
    public AsyncAPISchema getContains() {
        return this.contains;
    }

    @Nullable
    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    @Nullable
    public Integer getMinProperties() {
        return this.minProperties;
    }

    @Nullable
    public List<String> getRequired() {
        return this.required;
    }

    @Nullable
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Nullable
    public Map<String, AsyncAPISchema> getPatternProperties() {
        return this.patternProperties;
    }

    @Nullable
    public Object getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Nullable
    public Object getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public AsyncAPISchema getPropertyNames() {
        return this.propertyNames;
    }

    @Nullable
    public AsyncAPISchema getIfValue() {
        return this.ifValue;
    }

    @Nullable
    public AsyncAPISchema getThenValue() {
        return this.thenValue;
    }

    @Nullable
    public AsyncAPISchema getElseValue() {
        return this.elseValue;
    }

    @Nullable
    public List<AsyncAPISchema> getAllOf() {
        return this.allOf;
    }

    @Nullable
    public List<AsyncAPISchema> getAnyOf() {
        return this.anyOf;
    }

    @Nullable
    public List<AsyncAPISchema> getOneOf() {
        return this.oneOf;
    }

    @Nullable
    public AsyncAPISchema getNot() {
        return this.not;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Nullable
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Nullable
    public String getContentMediaType() {
        return this.contentMediaType;
    }

    @Nullable
    public Map<String, AsyncAPISchema> getDefinitions() {
        return this.definitions;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Nullable
    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    @Nullable
    public List<Object> getExamples() {
        return this.examples;
    }

    @Nullable
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Nullable
    public Object getExternalDocs() {
        return this.externalDocs;
    }

    @Nullable
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="$id")
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @JsonProperty(value="$schema")
    public void setSchema(@Nullable String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="$ref")
    public void setRef(@Nullable String ref) {
        this.ref = ref;
    }

    @JsonProperty(value="$comment")
    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    @JsonProperty(value="type")
    public void setType(@Nullable Object type) {
        this.type = type;
    }

    @JsonProperty(value="enum")
    public void setEnumValue(@Nullable List<Object> enumValue) {
        this.enumValue = enumValue;
    }

    @JsonProperty(value="const")
    public void setConstValue(@Nullable Object constValue) {
        this.constValue = constValue;
    }

    @JsonProperty(value="multipleOf")
    public void setMultipleOf(@Nullable Number multipleOf) {
        this.multipleOf = multipleOf;
    }

    @JsonProperty(value="maximum")
    public void setMaximum(@Nullable BigDecimal maximum) {
        this.maximum = maximum;
    }

    @JsonProperty(value="exclusiveMaximum")
    public void setExclusiveMaximum(@Nullable BigDecimal exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    @JsonProperty(value="minimum")
    public void setMinimum(@Nullable BigDecimal minimum) {
        this.minimum = minimum;
    }

    @JsonProperty(value="exclusiveMinimum")
    public void setExclusiveMinimum(@Nullable BigDecimal exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    @JsonProperty(value="maxLength")
    public void setMaxLength(@Nullable Integer maxLength) {
        this.maxLength = maxLength;
    }

    @JsonProperty(value="minLength")
    public void setMinLength(@Nullable Integer minLength) {
        this.minLength = minLength;
    }

    @JsonProperty(value="pattern")
    public void setPattern(@Nullable String pattern) {
        this.pattern = pattern;
    }

    @JsonProperty(value="items")
    public void setItems(@Nullable Object items) {
        this.items = items;
    }

    @JsonProperty(value="additionalItems")
    public void setAdditionalItems(@Nullable AsyncAPISchema additionalItems) {
        this.additionalItems = additionalItems;
    }

    @JsonProperty(value="maxItems")
    public void setMaxItems(@Nullable Integer maxItems) {
        this.maxItems = maxItems;
    }

    @JsonProperty(value="minItems")
    public void setMinItems(@Nullable Integer minItems) {
        this.minItems = minItems;
    }

    @JsonProperty(value="uniqueItems")
    public void setUniqueItems(@Nullable Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @JsonProperty(value="contains")
    public void setContains(@Nullable AsyncAPISchema contains) {
        this.contains = contains;
    }

    @JsonProperty(value="maxProperties")
    public void setMaxProperties(@Nullable Integer maxProperties) {
        this.maxProperties = maxProperties;
    }

    @JsonProperty(value="minProperties")
    public void setMinProperties(@Nullable Integer minProperties) {
        this.minProperties = minProperties;
    }

    @JsonProperty(value="required")
    public void setRequired(@Nullable List<String> required) {
        this.required = required;
    }

    @JsonProperty(value="properties")
    public void setProperties(@Nullable Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="patternProperties")
    public void setPatternProperties(@Nullable Map<String, AsyncAPISchema> patternProperties) {
        this.patternProperties = patternProperties;
    }

    @JsonProperty(value="additionalProperties")
    public void setAdditionalProperties(@Nullable Object additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="dependencies")
    public void setDependencies(@Nullable Object dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty(value="propertyNames")
    public void setPropertyNames(@Nullable AsyncAPISchema propertyNames) {
        this.propertyNames = propertyNames;
    }

    @JsonProperty(value="if")
    public void setIfValue(@Nullable AsyncAPISchema ifValue) {
        this.ifValue = ifValue;
    }

    @JsonProperty(value="then")
    public void setThenValue(@Nullable AsyncAPISchema thenValue) {
        this.thenValue = thenValue;
    }

    @JsonProperty(value="else")
    public void setElseValue(@Nullable AsyncAPISchema elseValue) {
        this.elseValue = elseValue;
    }

    @JsonProperty(value="allOf")
    public void setAllOf(@Nullable List<AsyncAPISchema> allOf) {
        this.allOf = allOf;
    }

    @JsonProperty(value="anyOf")
    public void setAnyOf(@Nullable List<AsyncAPISchema> anyOf) {
        this.anyOf = anyOf;
    }

    @JsonProperty(value="oneOf")
    public void setOneOf(@Nullable List<AsyncAPISchema> oneOf) {
        this.oneOf = oneOf;
    }

    @JsonProperty(value="not")
    public void setNot(@Nullable AsyncAPISchema not) {
        this.not = not;
    }

    @JsonProperty(value="format")
    public void setFormat(@Nullable String format) {
        this.format = format;
    }

    @JsonProperty(value="contentEncoding")
    public void setContentEncoding(@Nullable String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    @JsonProperty(value="contentMediaType")
    public void setContentMediaType(@Nullable String contentMediaType) {
        this.contentMediaType = contentMediaType;
    }

    @JsonProperty(value="definitions")
    public void setDefinitions(@Nullable Map<String, AsyncAPISchema> definitions) {
        this.definitions = definitions;
    }

    @JsonProperty(value="title")
    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @JsonProperty(value="description")
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @JsonProperty(value="default")
    public void setDefaultValue(@Nullable Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @JsonProperty(value="readOnly")
    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @JsonProperty(value="writeOnly")
    public void setWriteOnly(@Nullable Boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    @JsonProperty(value="examples")
    public void setExamples(@Nullable List<Object> examples) {
        this.examples = examples;
    }

    @JsonProperty(value="discriminator")
    public void setDiscriminator(@Nullable String discriminator) {
        this.discriminator = discriminator;
    }

    @JsonProperty(value="externalDocs")
    public void setExternalDocs(@Nullable Object externalDocs) {
        this.externalDocs = externalDocs;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(@Nullable Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public String toString() {
        return "AsyncAPISchema(id=" + this.getId() + ", schema=" + this.getSchema() + ", ref=" + this.getRef() + ", comment=" + this.getComment() + ", type=" + this.getType() + ", enumValue=" + this.getEnumValue() + ", constValue=" + this.getConstValue() + ", multipleOf=" + this.getMultipleOf() + ", maximum=" + this.getMaximum() + ", exclusiveMaximum=" + this.getExclusiveMaximum() + ", minimum=" + this.getMinimum() + ", exclusiveMinimum=" + this.getExclusiveMinimum() + ", maxLength=" + this.getMaxLength() + ", minLength=" + this.getMinLength() + ", pattern=" + this.getPattern() + ", items=" + this.getItems() + ", additionalItems=" + this.getAdditionalItems() + ", maxItems=" + this.getMaxItems() + ", minItems=" + this.getMinItems() + ", uniqueItems=" + this.getUniqueItems() + ", contains=" + this.getContains() + ", maxProperties=" + this.getMaxProperties() + ", minProperties=" + this.getMinProperties() + ", required=" + this.getRequired() + ", properties=" + this.getProperties() + ", patternProperties=" + this.getPatternProperties() + ", additionalProperties=" + this.getAdditionalProperties() + ", dependencies=" + this.getDependencies() + ", propertyNames=" + this.getPropertyNames() + ", ifValue=" + this.getIfValue() + ", thenValue=" + this.getThenValue() + ", elseValue=" + this.getElseValue() + ", allOf=" + this.getAllOf() + ", anyOf=" + this.getAnyOf() + ", oneOf=" + this.getOneOf() + ", not=" + this.getNot() + ", format=" + this.getFormat() + ", contentEncoding=" + this.getContentEncoding() + ", contentMediaType=" + this.getContentMediaType() + ", definitions=" + this.getDefinitions() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", defaultValue=" + this.getDefaultValue() + ", readOnly=" + this.getReadOnly() + ", writeOnly=" + this.getWriteOnly() + ", examples=" + this.getExamples() + ", discriminator=" + this.getDiscriminator() + ", externalDocs=" + this.getExternalDocs() + ", deprecated=" + this.getDeprecated() + ")";
    }

    public AsyncAPISchema() {
    }

    public AsyncAPISchema(@Nullable String id, @Nullable String schema, @Nullable String ref, @Nullable String comment, @Nullable Object type, @Nullable List<Object> enumValue, @Nullable Object constValue, @Nullable Number multipleOf, @Nullable BigDecimal maximum, @Nullable BigDecimal exclusiveMaximum, @Nullable BigDecimal minimum, @Nullable BigDecimal exclusiveMinimum, @Nullable Integer maxLength, @Nullable Integer minLength, @Nullable String pattern, @Nullable Object items, @Nullable AsyncAPISchema additionalItems, @Nullable Integer maxItems, @Nullable Integer minItems, @Nullable Boolean uniqueItems, @Nullable AsyncAPISchema contains, @Nullable Integer maxProperties, @Nullable Integer minProperties, @Nullable List<String> required, @Nullable Map<String, Object> properties, @Nullable Map<String, AsyncAPISchema> patternProperties, @Nullable Object additionalProperties, @Nullable Object dependencies, @Nullable AsyncAPISchema propertyNames, @Nullable AsyncAPISchema ifValue, @Nullable AsyncAPISchema thenValue, @Nullable AsyncAPISchema elseValue, @Nullable List<AsyncAPISchema> allOf, @Nullable List<AsyncAPISchema> anyOf, @Nullable List<AsyncAPISchema> oneOf, @Nullable AsyncAPISchema not, @Nullable String format, @Nullable String contentEncoding, @Nullable String contentMediaType, @Nullable Map<String, AsyncAPISchema> definitions, @Nullable String title, @Nullable String description, @Nullable Object defaultValue, @Nullable Boolean readOnly, @Nullable Boolean writeOnly, @Nullable List<Object> examples, @Nullable String discriminator, @Nullable Object externalDocs, @Nullable Boolean deprecated) {
        this.id = id;
        this.schema = schema;
        this.ref = ref;
        this.comment = comment;
        this.type = type;
        this.enumValue = enumValue;
        this.constValue = constValue;
        this.multipleOf = multipleOf;
        this.maximum = maximum;
        this.exclusiveMaximum = exclusiveMaximum;
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum;
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.pattern = pattern;
        this.items = items;
        this.additionalItems = additionalItems;
        this.maxItems = maxItems;
        this.minItems = minItems;
        this.uniqueItems = uniqueItems;
        this.contains = contains;
        this.maxProperties = maxProperties;
        this.minProperties = minProperties;
        this.required = required;
        this.properties = properties;
        this.patternProperties = patternProperties;
        this.additionalProperties = additionalProperties;
        this.dependencies = dependencies;
        this.propertyNames = propertyNames;
        this.ifValue = ifValue;
        this.thenValue = thenValue;
        this.elseValue = elseValue;
        this.allOf = allOf;
        this.anyOf = anyOf;
        this.oneOf = oneOf;
        this.not = not;
        this.format = format;
        this.contentEncoding = contentEncoding;
        this.contentMediaType = contentMediaType;
        this.definitions = definitions;
        this.title = title;
        this.description = description;
        this.defaultValue = defaultValue;
        this.readOnly = readOnly;
        this.writeOnly = writeOnly;
        this.examples = examples;
        this.discriminator = discriminator;
        this.externalDocs = externalDocs;
        this.deprecated = deprecated;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncAPISchema)) {
            return false;
        }
        AsyncAPISchema other = (AsyncAPISchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Object this$type = this.getType();
        Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Object> this$enumValue = this.getEnumValue();
        List<Object> other$enumValue = other.getEnumValue();
        if (this$enumValue == null ? other$enumValue != null : !((Object)this$enumValue).equals(other$enumValue)) {
            return false;
        }
        Object this$constValue = this.getConstValue();
        Object other$constValue = other.getConstValue();
        if (this$constValue == null ? other$constValue != null : !this$constValue.equals(other$constValue)) {
            return false;
        }
        Number this$multipleOf = this.getMultipleOf();
        Number other$multipleOf = other.getMultipleOf();
        if (this$multipleOf == null ? other$multipleOf != null : !this$multipleOf.equals(other$multipleOf)) {
            return false;
        }
        BigDecimal this$maximum = this.getMaximum();
        BigDecimal other$maximum = other.getMaximum();
        if (this$maximum == null ? other$maximum != null : !((Object)this$maximum).equals(other$maximum)) {
            return false;
        }
        BigDecimal this$exclusiveMaximum = this.getExclusiveMaximum();
        BigDecimal other$exclusiveMaximum = other.getExclusiveMaximum();
        if (this$exclusiveMaximum == null ? other$exclusiveMaximum != null : !((Object)this$exclusiveMaximum).equals(other$exclusiveMaximum)) {
            return false;
        }
        BigDecimal this$minimum = this.getMinimum();
        BigDecimal other$minimum = other.getMinimum();
        if (this$minimum == null ? other$minimum != null : !((Object)this$minimum).equals(other$minimum)) {
            return false;
        }
        BigDecimal this$exclusiveMinimum = this.getExclusiveMinimum();
        BigDecimal other$exclusiveMinimum = other.getExclusiveMinimum();
        if (this$exclusiveMinimum == null ? other$exclusiveMinimum != null : !((Object)this$exclusiveMinimum).equals(other$exclusiveMinimum)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$minLength = this.getMinLength();
        Integer other$minLength = other.getMinLength();
        if (this$minLength == null ? other$minLength != null : !((Object)this$minLength).equals(other$minLength)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Object this$items = this.getItems();
        Object other$items = other.getItems();
        if (this$items == null ? other$items != null : !this$items.equals(other$items)) {
            return false;
        }
        AsyncAPISchema this$additionalItems = this.getAdditionalItems();
        AsyncAPISchema other$additionalItems = other.getAdditionalItems();
        if (this$additionalItems == null ? other$additionalItems != null : !((Object)this$additionalItems).equals(other$additionalItems)) {
            return false;
        }
        Integer this$maxItems = this.getMaxItems();
        Integer other$maxItems = other.getMaxItems();
        if (this$maxItems == null ? other$maxItems != null : !((Object)this$maxItems).equals(other$maxItems)) {
            return false;
        }
        Integer this$minItems = this.getMinItems();
        Integer other$minItems = other.getMinItems();
        if (this$minItems == null ? other$minItems != null : !((Object)this$minItems).equals(other$minItems)) {
            return false;
        }
        Boolean this$uniqueItems = this.getUniqueItems();
        Boolean other$uniqueItems = other.getUniqueItems();
        if (this$uniqueItems == null ? other$uniqueItems != null : !((Object)this$uniqueItems).equals(other$uniqueItems)) {
            return false;
        }
        AsyncAPISchema this$contains = this.getContains();
        AsyncAPISchema other$contains = other.getContains();
        if (this$contains == null ? other$contains != null : !((Object)this$contains).equals(other$contains)) {
            return false;
        }
        Integer this$maxProperties = this.getMaxProperties();
        Integer other$maxProperties = other.getMaxProperties();
        if (this$maxProperties == null ? other$maxProperties != null : !((Object)this$maxProperties).equals(other$maxProperties)) {
            return false;
        }
        Integer this$minProperties = this.getMinProperties();
        Integer other$minProperties = other.getMinProperties();
        if (this$minProperties == null ? other$minProperties != null : !((Object)this$minProperties).equals(other$minProperties)) {
            return false;
        }
        List<String> this$required = this.getRequired();
        List<String> other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Map<String, AsyncAPISchema> this$patternProperties = this.getPatternProperties();
        Map<String, AsyncAPISchema> other$patternProperties = other.getPatternProperties();
        if (this$patternProperties == null ? other$patternProperties != null : !((Object)this$patternProperties).equals(other$patternProperties)) {
            return false;
        }
        Object this$additionalProperties = this.getAdditionalProperties();
        Object other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !this$additionalProperties.equals(other$additionalProperties)) {
            return false;
        }
        Object this$dependencies = this.getDependencies();
        Object other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies)) {
            return false;
        }
        AsyncAPISchema this$propertyNames = this.getPropertyNames();
        AsyncAPISchema other$propertyNames = other.getPropertyNames();
        if (this$propertyNames == null ? other$propertyNames != null : !((Object)this$propertyNames).equals(other$propertyNames)) {
            return false;
        }
        AsyncAPISchema this$ifValue = this.getIfValue();
        AsyncAPISchema other$ifValue = other.getIfValue();
        if (this$ifValue == null ? other$ifValue != null : !((Object)this$ifValue).equals(other$ifValue)) {
            return false;
        }
        AsyncAPISchema this$thenValue = this.getThenValue();
        AsyncAPISchema other$thenValue = other.getThenValue();
        if (this$thenValue == null ? other$thenValue != null : !((Object)this$thenValue).equals(other$thenValue)) {
            return false;
        }
        AsyncAPISchema this$elseValue = this.getElseValue();
        AsyncAPISchema other$elseValue = other.getElseValue();
        if (this$elseValue == null ? other$elseValue != null : !((Object)this$elseValue).equals(other$elseValue)) {
            return false;
        }
        List<AsyncAPISchema> this$allOf = this.getAllOf();
        List<AsyncAPISchema> other$allOf = other.getAllOf();
        if (this$allOf == null ? other$allOf != null : !((Object)this$allOf).equals(other$allOf)) {
            return false;
        }
        List<AsyncAPISchema> this$anyOf = this.getAnyOf();
        List<AsyncAPISchema> other$anyOf = other.getAnyOf();
        if (this$anyOf == null ? other$anyOf != null : !((Object)this$anyOf).equals(other$anyOf)) {
            return false;
        }
        List<AsyncAPISchema> this$oneOf = this.getOneOf();
        List<AsyncAPISchema> other$oneOf = other.getOneOf();
        if (this$oneOf == null ? other$oneOf != null : !((Object)this$oneOf).equals(other$oneOf)) {
            return false;
        }
        AsyncAPISchema this$not = this.getNot();
        AsyncAPISchema other$not = other.getNot();
        if (this$not == null ? other$not != null : !((Object)this$not).equals(other$not)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$contentEncoding = this.getContentEncoding();
        String other$contentEncoding = other.getContentEncoding();
        if (this$contentEncoding == null ? other$contentEncoding != null : !this$contentEncoding.equals(other$contentEncoding)) {
            return false;
        }
        String this$contentMediaType = this.getContentMediaType();
        String other$contentMediaType = other.getContentMediaType();
        if (this$contentMediaType == null ? other$contentMediaType != null : !this$contentMediaType.equals(other$contentMediaType)) {
            return false;
        }
        Map<String, AsyncAPISchema> this$definitions = this.getDefinitions();
        Map<String, AsyncAPISchema> other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        Boolean this$writeOnly = this.getWriteOnly();
        Boolean other$writeOnly = other.getWriteOnly();
        if (this$writeOnly == null ? other$writeOnly != null : !((Object)this$writeOnly).equals(other$writeOnly)) {
            return false;
        }
        List<Object> this$examples = this.getExamples();
        List<Object> other$examples = other.getExamples();
        if (this$examples == null ? other$examples != null : !((Object)this$examples).equals(other$examples)) {
            return false;
        }
        String this$discriminator = this.getDiscriminator();
        String other$discriminator = other.getDiscriminator();
        if (this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator)) {
            return false;
        }
        Object this$externalDocs = this.getExternalDocs();
        Object other$externalDocs = other.getExternalDocs();
        if (this$externalDocs == null ? other$externalDocs != null : !this$externalDocs.equals(other$externalDocs)) {
            return false;
        }
        Boolean this$deprecated = this.getDeprecated();
        Boolean other$deprecated = other.getDeprecated();
        return !(this$deprecated == null ? other$deprecated != null : !((Object)this$deprecated).equals(other$deprecated));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AsyncAPISchema;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Object $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Object> $enumValue = this.getEnumValue();
        result = result * 59 + ($enumValue == null ? 43 : ((Object)$enumValue).hashCode());
        Object $constValue = this.getConstValue();
        result = result * 59 + ($constValue == null ? 43 : $constValue.hashCode());
        Number $multipleOf = this.getMultipleOf();
        result = result * 59 + ($multipleOf == null ? 43 : $multipleOf.hashCode());
        BigDecimal $maximum = this.getMaximum();
        result = result * 59 + ($maximum == null ? 43 : ((Object)$maximum).hashCode());
        BigDecimal $exclusiveMaximum = this.getExclusiveMaximum();
        result = result * 59 + ($exclusiveMaximum == null ? 43 : ((Object)$exclusiveMaximum).hashCode());
        BigDecimal $minimum = this.getMinimum();
        result = result * 59 + ($minimum == null ? 43 : ((Object)$minimum).hashCode());
        BigDecimal $exclusiveMinimum = this.getExclusiveMinimum();
        result = result * 59 + ($exclusiveMinimum == null ? 43 : ((Object)$exclusiveMinimum).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $minLength = this.getMinLength();
        result = result * 59 + ($minLength == null ? 43 : ((Object)$minLength).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Object $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : $items.hashCode());
        AsyncAPISchema $additionalItems = this.getAdditionalItems();
        result = result * 59 + ($additionalItems == null ? 43 : ((Object)$additionalItems).hashCode());
        Integer $maxItems = this.getMaxItems();
        result = result * 59 + ($maxItems == null ? 43 : ((Object)$maxItems).hashCode());
        Integer $minItems = this.getMinItems();
        result = result * 59 + ($minItems == null ? 43 : ((Object)$minItems).hashCode());
        Boolean $uniqueItems = this.getUniqueItems();
        result = result * 59 + ($uniqueItems == null ? 43 : ((Object)$uniqueItems).hashCode());
        AsyncAPISchema $contains = this.getContains();
        result = result * 59 + ($contains == null ? 43 : ((Object)$contains).hashCode());
        Integer $maxProperties = this.getMaxProperties();
        result = result * 59 + ($maxProperties == null ? 43 : ((Object)$maxProperties).hashCode());
        Integer $minProperties = this.getMinProperties();
        result = result * 59 + ($minProperties == null ? 43 : ((Object)$minProperties).hashCode());
        List<String> $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Map<String, AsyncAPISchema> $patternProperties = this.getPatternProperties();
        result = result * 59 + ($patternProperties == null ? 43 : ((Object)$patternProperties).hashCode());
        Object $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : $additionalProperties.hashCode());
        Object $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
        AsyncAPISchema $propertyNames = this.getPropertyNames();
        result = result * 59 + ($propertyNames == null ? 43 : ((Object)$propertyNames).hashCode());
        AsyncAPISchema $ifValue = this.getIfValue();
        result = result * 59 + ($ifValue == null ? 43 : ((Object)$ifValue).hashCode());
        AsyncAPISchema $thenValue = this.getThenValue();
        result = result * 59 + ($thenValue == null ? 43 : ((Object)$thenValue).hashCode());
        AsyncAPISchema $elseValue = this.getElseValue();
        result = result * 59 + ($elseValue == null ? 43 : ((Object)$elseValue).hashCode());
        List<AsyncAPISchema> $allOf = this.getAllOf();
        result = result * 59 + ($allOf == null ? 43 : ((Object)$allOf).hashCode());
        List<AsyncAPISchema> $anyOf = this.getAnyOf();
        result = result * 59 + ($anyOf == null ? 43 : ((Object)$anyOf).hashCode());
        List<AsyncAPISchema> $oneOf = this.getOneOf();
        result = result * 59 + ($oneOf == null ? 43 : ((Object)$oneOf).hashCode());
        AsyncAPISchema $not = this.getNot();
        result = result * 59 + ($not == null ? 43 : ((Object)$not).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $contentEncoding = this.getContentEncoding();
        result = result * 59 + ($contentEncoding == null ? 43 : $contentEncoding.hashCode());
        String $contentMediaType = this.getContentMediaType();
        result = result * 59 + ($contentMediaType == null ? 43 : $contentMediaType.hashCode());
        Map<String, AsyncAPISchema> $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        Boolean $writeOnly = this.getWriteOnly();
        result = result * 59 + ($writeOnly == null ? 43 : ((Object)$writeOnly).hashCode());
        List<Object> $examples = this.getExamples();
        result = result * 59 + ($examples == null ? 43 : ((Object)$examples).hashCode());
        String $discriminator = this.getDiscriminator();
        result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
        Object $externalDocs = this.getExternalDocs();
        result = result * 59 + ($externalDocs == null ? 43 : $externalDocs.hashCode());
        Boolean $deprecated = this.getDeprecated();
        result = result * 59 + ($deprecated == null ? 43 : ((Object)$deprecated).hashCode());
        return result;
    }

    public static class AsyncAPISchemaBuilder {
        private String id;
        private String schema;
        private String ref;
        private String comment;
        private Object type;
        private List<Object> enumValue;
        private Object constValue;
        private Number multipleOf;
        private BigDecimal maximum;
        private BigDecimal exclusiveMaximum;
        private BigDecimal minimum;
        private BigDecimal exclusiveMinimum;
        private Integer maxLength;
        private Integer minLength;
        private String pattern;
        private Object items;
        private AsyncAPISchema additionalItems;
        private Integer maxItems;
        private Integer minItems;
        private Boolean uniqueItems;
        private AsyncAPISchema contains;
        private Integer maxProperties;
        private Integer minProperties;
        private List<String> required;
        private Map<String, Object> properties;
        private Map<String, AsyncAPISchema> patternProperties;
        private Object additionalProperties;
        private Object dependencies;
        private AsyncAPISchema propertyNames;
        private AsyncAPISchema ifValue;
        private AsyncAPISchema thenValue;
        private AsyncAPISchema elseValue;
        private List<AsyncAPISchema> allOf;
        private List<AsyncAPISchema> anyOf;
        private List<AsyncAPISchema> oneOf;
        private AsyncAPISchema not;
        private String format;
        private String contentEncoding;
        private String contentMediaType;
        private Map<String, AsyncAPISchema> definitions;
        private String title;
        private String description;
        private Object defaultValue;
        private Boolean readOnly;
        private Boolean writeOnly;
        private List<Object> examples;
        private String discriminator;
        private Object externalDocs;
        private Boolean deprecated;

        AsyncAPISchemaBuilder() {
        }

        @JsonProperty(value="$id")
        public AsyncAPISchemaBuilder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="$schema")
        public AsyncAPISchemaBuilder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        @JsonProperty(value="$ref")
        public AsyncAPISchemaBuilder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @JsonProperty(value="$comment")
        public AsyncAPISchemaBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="type")
        public AsyncAPISchemaBuilder type(@Nullable Object type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="enum")
        public AsyncAPISchemaBuilder enumValue(@Nullable List<Object> enumValue) {
            this.enumValue = enumValue;
            return this;
        }

        @JsonProperty(value="const")
        public AsyncAPISchemaBuilder constValue(@Nullable Object constValue) {
            this.constValue = constValue;
            return this;
        }

        @JsonProperty(value="multipleOf")
        public AsyncAPISchemaBuilder multipleOf(@Nullable Number multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        @JsonProperty(value="maximum")
        public AsyncAPISchemaBuilder maximum(@Nullable BigDecimal maximum) {
            this.maximum = maximum;
            return this;
        }

        @JsonProperty(value="exclusiveMaximum")
        public AsyncAPISchemaBuilder exclusiveMaximum(@Nullable BigDecimal exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        @JsonProperty(value="minimum")
        public AsyncAPISchemaBuilder minimum(@Nullable BigDecimal minimum) {
            this.minimum = minimum;
            return this;
        }

        @JsonProperty(value="exclusiveMinimum")
        public AsyncAPISchemaBuilder exclusiveMinimum(@Nullable BigDecimal exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        @JsonProperty(value="maxLength")
        public AsyncAPISchemaBuilder maxLength(@Nullable Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @JsonProperty(value="minLength")
        public AsyncAPISchemaBuilder minLength(@Nullable Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        @JsonProperty(value="pattern")
        public AsyncAPISchemaBuilder pattern(@Nullable String pattern) {
            this.pattern = pattern;
            return this;
        }

        @JsonProperty(value="items")
        public AsyncAPISchemaBuilder items(@Nullable Object items) {
            this.items = items;
            return this;
        }

        @JsonProperty(value="additionalItems")
        public AsyncAPISchemaBuilder additionalItems(@Nullable AsyncAPISchema additionalItems) {
            this.additionalItems = additionalItems;
            return this;
        }

        @JsonProperty(value="maxItems")
        public AsyncAPISchemaBuilder maxItems(@Nullable Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @JsonProperty(value="minItems")
        public AsyncAPISchemaBuilder minItems(@Nullable Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        @JsonProperty(value="uniqueItems")
        public AsyncAPISchemaBuilder uniqueItems(@Nullable Boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }

        @JsonProperty(value="contains")
        public AsyncAPISchemaBuilder contains(@Nullable AsyncAPISchema contains) {
            this.contains = contains;
            return this;
        }

        @JsonProperty(value="maxProperties")
        public AsyncAPISchemaBuilder maxProperties(@Nullable Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        @JsonProperty(value="minProperties")
        public AsyncAPISchemaBuilder minProperties(@Nullable Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        @JsonProperty(value="required")
        public AsyncAPISchemaBuilder required(@Nullable List<String> required) {
            this.required = required;
            return this;
        }

        @JsonProperty(value="properties")
        public AsyncAPISchemaBuilder properties(@Nullable Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        @JsonProperty(value="patternProperties")
        public AsyncAPISchemaBuilder patternProperties(@Nullable Map<String, AsyncAPISchema> patternProperties) {
            this.patternProperties = patternProperties;
            return this;
        }

        @JsonProperty(value="additionalProperties")
        public AsyncAPISchemaBuilder additionalProperties(@Nullable Object additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        @JsonProperty(value="dependencies")
        public AsyncAPISchemaBuilder dependencies(@Nullable Object dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @JsonProperty(value="propertyNames")
        public AsyncAPISchemaBuilder propertyNames(@Nullable AsyncAPISchema propertyNames) {
            this.propertyNames = propertyNames;
            return this;
        }

        @JsonProperty(value="if")
        public AsyncAPISchemaBuilder ifValue(@Nullable AsyncAPISchema ifValue) {
            this.ifValue = ifValue;
            return this;
        }

        @JsonProperty(value="then")
        public AsyncAPISchemaBuilder thenValue(@Nullable AsyncAPISchema thenValue) {
            this.thenValue = thenValue;
            return this;
        }

        @JsonProperty(value="else")
        public AsyncAPISchemaBuilder elseValue(@Nullable AsyncAPISchema elseValue) {
            this.elseValue = elseValue;
            return this;
        }

        @JsonProperty(value="allOf")
        public AsyncAPISchemaBuilder allOf(@Nullable List<AsyncAPISchema> allOf) {
            this.allOf = allOf;
            return this;
        }

        @JsonProperty(value="anyOf")
        public AsyncAPISchemaBuilder anyOf(@Nullable List<AsyncAPISchema> anyOf) {
            this.anyOf = anyOf;
            return this;
        }

        @JsonProperty(value="oneOf")
        public AsyncAPISchemaBuilder oneOf(@Nullable List<AsyncAPISchema> oneOf) {
            this.oneOf = oneOf;
            return this;
        }

        @JsonProperty(value="not")
        public AsyncAPISchemaBuilder not(@Nullable AsyncAPISchema not) {
            this.not = not;
            return this;
        }

        @JsonProperty(value="format")
        public AsyncAPISchemaBuilder format(@Nullable String format) {
            this.format = format;
            return this;
        }

        @JsonProperty(value="contentEncoding")
        public AsyncAPISchemaBuilder contentEncoding(@Nullable String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        @JsonProperty(value="contentMediaType")
        public AsyncAPISchemaBuilder contentMediaType(@Nullable String contentMediaType) {
            this.contentMediaType = contentMediaType;
            return this;
        }

        @JsonProperty(value="definitions")
        public AsyncAPISchemaBuilder definitions(@Nullable Map<String, AsyncAPISchema> definitions) {
            this.definitions = definitions;
            return this;
        }

        @JsonProperty(value="title")
        public AsyncAPISchemaBuilder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        public AsyncAPISchemaBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="default")
        public AsyncAPISchemaBuilder defaultValue(@Nullable Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @JsonProperty(value="readOnly")
        public AsyncAPISchemaBuilder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @JsonProperty(value="writeOnly")
        public AsyncAPISchemaBuilder writeOnly(@Nullable Boolean writeOnly) {
            this.writeOnly = writeOnly;
            return this;
        }

        @JsonProperty(value="examples")
        public AsyncAPISchemaBuilder examples(@Nullable List<Object> examples) {
            this.examples = examples;
            return this;
        }

        @JsonProperty(value="discriminator")
        public AsyncAPISchemaBuilder discriminator(@Nullable String discriminator) {
            this.discriminator = discriminator;
            return this;
        }

        @JsonProperty(value="externalDocs")
        public AsyncAPISchemaBuilder externalDocs(@Nullable Object externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        @JsonProperty(value="deprecated")
        public AsyncAPISchemaBuilder deprecated(@Nullable Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public AsyncAPISchema build() {
            return new AsyncAPISchema(this.id, this.schema, this.ref, this.comment, this.type, this.enumValue, this.constValue, this.multipleOf, this.maximum, this.exclusiveMaximum, this.minimum, this.exclusiveMinimum, this.maxLength, this.minLength, this.pattern, this.items, this.additionalItems, this.maxItems, this.minItems, this.uniqueItems, this.contains, this.maxProperties, this.minProperties, this.required, this.properties, this.patternProperties, this.additionalProperties, this.dependencies, this.propertyNames, this.ifValue, this.thenValue, this.elseValue, this.allOf, this.anyOf, this.oneOf, this.not, this.format, this.contentEncoding, this.contentMediaType, this.definitions, this.title, this.description, this.defaultValue, this.readOnly, this.writeOnly, this.examples, this.discriminator, this.externalDocs, this.deprecated);
        }

        public String toString() {
            return "AsyncAPISchema.AsyncAPISchemaBuilder(id=" + this.id + ", schema=" + this.schema + ", ref=" + this.ref + ", comment=" + this.comment + ", type=" + this.type + ", enumValue=" + this.enumValue + ", constValue=" + this.constValue + ", multipleOf=" + this.multipleOf + ", maximum=" + this.maximum + ", exclusiveMaximum=" + this.exclusiveMaximum + ", minimum=" + this.minimum + ", exclusiveMinimum=" + this.exclusiveMinimum + ", maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", pattern=" + this.pattern + ", items=" + this.items + ", additionalItems=" + this.additionalItems + ", maxItems=" + this.maxItems + ", minItems=" + this.minItems + ", uniqueItems=" + this.uniqueItems + ", contains=" + this.contains + ", maxProperties=" + this.maxProperties + ", minProperties=" + this.minProperties + ", required=" + this.required + ", properties=" + this.properties + ", patternProperties=" + this.patternProperties + ", additionalProperties=" + this.additionalProperties + ", dependencies=" + this.dependencies + ", propertyNames=" + this.propertyNames + ", ifValue=" + this.ifValue + ", thenValue=" + this.thenValue + ", elseValue=" + this.elseValue + ", allOf=" + this.allOf + ", anyOf=" + this.anyOf + ", oneOf=" + this.oneOf + ", not=" + this.not + ", format=" + this.format + ", contentEncoding=" + this.contentEncoding + ", contentMediaType=" + this.contentMediaType + ", definitions=" + this.definitions + ", title=" + this.title + ", description=" + this.description + ", defaultValue=" + this.defaultValue + ", readOnly=" + this.readOnly + ", writeOnly=" + this.writeOnly + ", examples=" + this.examples + ", discriminator=" + this.discriminator + ", externalDocs=" + this.externalDocs + ", deprecated=" + this.deprecated + ")";
        }
    }
}

