/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.schema.avro.v1._9_0.jackson;

import com.asyncapi.v3.Reference;
import com.asyncapi.v3.schema.avro.v1._9_0.AvroSchema;
import com.asyncapi.v3.schema.avro.v1._9_0.AvroSchemaUnion;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class AvroSchemaDeserializer
extends JsonDeserializer<Object> {
    public final Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        return this.chooseKnownPojo(node, objectCodec);
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            JsonNodeType nodeType = jsonNode.getNodeType();
            switch (nodeType) {
                case ARRAY: {
                    AvroSchemaUnion avroSchemaUnion = this.readAsUnion((ArrayNode)jsonNode, objectCodec);
                    return avroSchemaUnion;
                }
                case OBJECT: {
                    Object object = this.readAvroSchema((ObjectNode)jsonNode, objectCodec);
                    return object;
                }
                case STRING: {
                    Object object = jsonParser.readValueAs(String.class);
                    return object;
                }
                case BOOLEAN: 
                case NUMBER: 
                case BINARY: 
                case POJO: 
                case MISSING: 
                case NULL: {
                    Object var6_10 = null;
                    return var6_10;
                }
            }
            Object var6_11 = null;
            return var6_11;
        }
    }

    private AvroSchemaUnion readAsUnion(ArrayNode arrayNode, ObjectCodec objectCodec) throws IOException {
        AvroSchemaUnion avroSchemaUnion = new AvroSchemaUnion();
        for (JsonNode childNode : arrayNode) {
            avroSchemaUnion.add(this.chooseKnownPojo(childNode, objectCodec));
        }
        return avroSchemaUnion;
    }

    private Object readAvroSchema(ObjectNode objectNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = objectNode.traverse(objectCodec);){
            if (objectNode.size() == 1 && objectNode.has("$ref")) {
                Object object = jsonParser.readValueAs(Reference.class);
                return object;
            }
            Object object = jsonParser.readValueAs(AvroSchema.class);
            return object;
        }
    }
}

