/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.schema.avro.v1._9_0.jackson;

import com.asyncapi.v3.schema.avro.v1._9_0.AvroSchema;
import com.asyncapi.v3.schema.avro.v1._9_0.AvroSchemaUnion;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;

public class AvroTypeDeserializer
extends JsonDeserializer<Object> {
    public final Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        return this.chooseKnownPojo(node, objectCodec);
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            JsonNodeType nodeType = jsonNode.getNodeType();
            switch (nodeType) {
                case ARRAY: {
                    AvroSchemaUnion avroSchemaUnion = this.readAsUnion((ArrayNode)jsonNode, objectCodec);
                    return avroSchemaUnion;
                }
                case BOOLEAN: {
                    Boolean bl = jsonNode.asBoolean();
                    return bl;
                }
                case NUMBER: {
                    Object object = jsonParser.readValueAs(Number.class);
                    return object;
                }
                case OBJECT: {
                    Object object = jsonParser.readValueAs(AvroSchema.class);
                    return object;
                }
                case STRING: {
                    Object object = jsonParser.readValueAs(String.class);
                    return object;
                }
                case BINARY: 
                case POJO: 
                case MISSING: 
                case NULL: {
                    Object var6_12 = null;
                    return var6_12;
                }
            }
            Object var6_13 = null;
            return var6_13;
        }
    }

    private AvroSchemaUnion readAsUnion(ArrayNode arrayNode, ObjectCodec objectCodec) throws IOException {
        AvroSchemaUnion avroSchemaUnion = new AvroSchemaUnion();
        for (JsonNode childNode : arrayNode) {
            avroSchemaUnion.add(this.chooseKnownPojo(childNode, objectCodec));
        }
        return avroSchemaUnion;
    }
}

