/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.security_scheme;

import com.asyncapi.v3.security_scheme.SecurityScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiKeySecurityScheme
extends SecurityScheme {
    @NotNull
    private ApiKeyLocation in = ApiKeyLocation.USER;

    public ApiKeySecurityScheme(@Nullable String description, @NotNull ApiKeyLocation in) {
        super(SecurityScheme.Type.API_KEY, description);
        this.in = in;
    }

    public static ApiKeySecuritySchemeBuilder apiKeyBuilder() {
        return new ApiKeySecuritySchemeBuilder();
    }

    @NotNull
    public ApiKeyLocation getIn() {
        return this.in;
    }

    public void setIn(@NotNull ApiKeyLocation in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        this.in = in;
    }

    @Override
    public String toString() {
        return "ApiKeySecurityScheme(in=" + (Object)((Object)this.getIn()) + ")";
    }

    public ApiKeySecurityScheme() {
    }

    public ApiKeySecurityScheme(@NotNull ApiKeyLocation in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        this.in = in;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiKeySecurityScheme)) {
            return false;
        }
        ApiKeySecurityScheme other = (ApiKeySecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApiKeyLocation this$in = this.getIn();
        ApiKeyLocation other$in = other.getIn();
        return !(this$in == null ? other$in != null : !((Object)((Object)this$in)).equals((Object)other$in));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApiKeySecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ApiKeyLocation $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)((Object)$in)).hashCode());
        return result;
    }

    public static class ApiKeySecuritySchemeBuilder {
        private String description;
        private ApiKeyLocation in;

        ApiKeySecuritySchemeBuilder() {
        }

        public ApiKeySecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public ApiKeySecuritySchemeBuilder in(@NotNull ApiKeyLocation in) {
            this.in = in;
            return this;
        }

        public ApiKeySecurityScheme build() {
            return new ApiKeySecurityScheme(this.description, this.in);
        }

        public String toString() {
            return "ApiKeySecurityScheme.ApiKeySecuritySchemeBuilder(description=" + this.description + ", in=" + (Object)((Object)this.in) + ")";
        }
    }

    public static enum ApiKeyLocation {
        USER,
        PASSWORD;

    }
}

