/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.security_scheme;

import com.asyncapi.v3.security_scheme.SecurityScheme;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenIdConnectSecurityScheme
extends SecurityScheme {
    @NotNull
    private String openIdConnectUrl = "";
    @Nullable
    private List<String> scopes;

    public OpenIdConnectSecurityScheme(@Nullable String description, @NotNull String openIdConnectUrl, @Nullable List<String> scopes) {
        super(SecurityScheme.Type.OPENID_CONNECT, description);
        this.openIdConnectUrl = openIdConnectUrl;
        this.scopes = scopes;
    }

    public static OpenIdConnectSecuritySchemeBuilder openIdBuilder() {
        return new OpenIdConnectSecuritySchemeBuilder();
    }

    @NotNull
    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setOpenIdConnectUrl(@NotNull String openIdConnectUrl) {
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    public void setScopes(@Nullable List<String> scopes) {
        this.scopes = scopes;
    }

    @Override
    public String toString() {
        return "OpenIdConnectSecurityScheme(openIdConnectUrl=" + this.getOpenIdConnectUrl() + ", scopes=" + this.getScopes() + ")";
    }

    public OpenIdConnectSecurityScheme() {
    }

    public OpenIdConnectSecurityScheme(@NotNull String openIdConnectUrl, @Nullable List<String> scopes) {
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenIdConnectSecurityScheme)) {
            return false;
        }
        OpenIdConnectSecurityScheme other = (OpenIdConnectSecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$openIdConnectUrl = this.getOpenIdConnectUrl();
        String other$openIdConnectUrl = other.getOpenIdConnectUrl();
        if (this$openIdConnectUrl == null ? other$openIdConnectUrl != null : !this$openIdConnectUrl.equals(other$openIdConnectUrl)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OpenIdConnectSecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $openIdConnectUrl = this.getOpenIdConnectUrl();
        result = result * 59 + ($openIdConnectUrl == null ? 43 : $openIdConnectUrl.hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    public static class OpenIdConnectSecuritySchemeBuilder {
        private String description;
        private String openIdConnectUrl;
        private List<String> scopes;

        OpenIdConnectSecuritySchemeBuilder() {
        }

        public OpenIdConnectSecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OpenIdConnectSecuritySchemeBuilder openIdConnectUrl(@NotNull String openIdConnectUrl) {
            this.openIdConnectUrl = openIdConnectUrl;
            return this;
        }

        public OpenIdConnectSecuritySchemeBuilder scopes(@Nullable List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public OpenIdConnectSecurityScheme build() {
            return new OpenIdConnectSecurityScheme(this.description, this.openIdConnectUrl, this.scopes);
        }

        public String toString() {
            return "OpenIdConnectSecurityScheme.OpenIdConnectSecuritySchemeBuilder(description=" + this.description + ", openIdConnectUrl=" + this.openIdConnectUrl + ", scopes=" + this.scopes + ")";
        }
    }
}

