/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.security_scheme.http;

import com.asyncapi.v3.security_scheme.SecurityScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpSecurityScheme
extends SecurityScheme {
    @NotNull
    private String scheme = "";
    @Nullable
    private String bearerFormat;

    public HttpSecurityScheme(@Nullable String description, @NotNull String scheme, @Nullable String bearerFormat) {
        super(SecurityScheme.Type.HTTP, description);
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }

    public static HttpSecuritySchemeBuilder httpBuilder() {
        return new HttpSecuritySchemeBuilder();
    }

    @NotNull
    public String getScheme() {
        return this.scheme;
    }

    @Nullable
    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public void setScheme(@NotNull String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
    }

    public void setBearerFormat(@Nullable String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    @Override
    public String toString() {
        return "HttpSecurityScheme(scheme=" + this.getScheme() + ", bearerFormat=" + this.getBearerFormat() + ")";
    }

    public HttpSecurityScheme() {
    }

    public HttpSecurityScheme(@NotNull String scheme, @Nullable String bearerFormat) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSecurityScheme)) {
            return false;
        }
        HttpSecurityScheme other = (HttpSecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$bearerFormat = this.getBearerFormat();
        String other$bearerFormat = other.getBearerFormat();
        return !(this$bearerFormat == null ? other$bearerFormat != null : !this$bearerFormat.equals(other$bearerFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpSecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $bearerFormat = this.getBearerFormat();
        result = result * 59 + ($bearerFormat == null ? 43 : $bearerFormat.hashCode());
        return result;
    }

    public static class HttpSecuritySchemeBuilder {
        private String description;
        private String scheme;
        private String bearerFormat;

        HttpSecuritySchemeBuilder() {
        }

        public HttpSecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public HttpSecuritySchemeBuilder scheme(@NotNull String scheme) {
            this.scheme = scheme;
            return this;
        }

        public HttpSecuritySchemeBuilder bearerFormat(@Nullable String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public HttpSecurityScheme build() {
            return new HttpSecurityScheme(this.description, this.scheme, this.bearerFormat);
        }

        public String toString() {
            return "HttpSecurityScheme.HttpSecuritySchemeBuilder(description=" + this.description + ", scheme=" + this.scheme + ", bearerFormat=" + this.bearerFormat + ")";
        }
    }
}

