/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.security_scheme.oauth2;

import com.asyncapi.v3.security_scheme.SecurityScheme;
import com.asyncapi.v3.security_scheme.oauth2.OAuthFlows;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuth2SecurityScheme
extends SecurityScheme {
    @NotNull
    private OAuthFlows flows = new OAuthFlows();
    @Nullable
    private List<String> scopes;

    public OAuth2SecurityScheme(@Nullable String description, @NotNull OAuthFlows flows, @Nullable List<String> scopes) {
        super(SecurityScheme.Type.OAUTH2, description);
        this.flows = flows;
        this.scopes = scopes;
    }

    public static OAuth2SecuritySchemeBuilder oauth2Builder() {
        return new OAuth2SecuritySchemeBuilder();
    }

    @NotNull
    public OAuthFlows getFlows() {
        return this.flows;
    }

    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setFlows(@NotNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    public void setScopes(@Nullable List<String> scopes) {
        this.scopes = scopes;
    }

    @Override
    public String toString() {
        return "OAuth2SecurityScheme(flows=" + this.getFlows() + ", scopes=" + this.getScopes() + ")";
    }

    public OAuth2SecurityScheme() {
    }

    public OAuth2SecurityScheme(@NotNull OAuthFlows flows, @Nullable List<String> scopes) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2SecurityScheme)) {
            return false;
        }
        OAuth2SecurityScheme other = (OAuth2SecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthFlows this$flows = this.getFlows();
        OAuthFlows other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2SecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OAuthFlows $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    public static class OAuth2SecuritySchemeBuilder {
        private String description;
        private OAuthFlows flows;
        private List<String> scopes;

        OAuth2SecuritySchemeBuilder() {
        }

        public OAuth2SecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OAuth2SecuritySchemeBuilder flows(@NotNull OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        public OAuth2SecuritySchemeBuilder scopes(@Nullable List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme(this.description, this.flows, this.scopes);
        }

        public String toString() {
            return "OAuth2SecurityScheme.OAuth2SecuritySchemeBuilder(description=" + this.description + ", flows=" + this.flows + ", scopes=" + this.scopes + ")";
        }
    }
}

