/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.amqp.v0._1_0.channel.exchange;

import com.asyncapi.bindings.amqp.v0._1_0.channel.exchange.AMQPChannelExchangeType;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.Size;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes AMQP 0-9-1 channel exchange properties.")
public class AMQPChannelExchangeProperties {
    @Size(max=255, message="Exchange name must not exceed 255 characters long.")
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the exchange. It MUST NOT exceed 255 characters long.")
    @Nullable
    private @Size(max=255, message="Exchange name must not exceed 255 characters long.") @Nullable String name;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type of the exchange. Can be either topic, direct, fanout, default or headers.")
    @Nullable
    private AMQPChannelExchangeType type;
    @JsonProperty(value="durable")
    @JsonPropertyDescription(value="Whether the exchange should survive broker restarts or not.")
    @Nullable
    private Boolean durable;
    @JsonProperty(value="autoDelete")
    @JsonPropertyDescription(value="Whether the exchange should be deleted when the last queue is unbound from it.")
    @Nullable
    private Boolean autoDelete;

    public static AMQPChannelExchangePropertiesBuilder builder() {
        return new AMQPChannelExchangePropertiesBuilder();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public AMQPChannelExchangeType getType() {
        return this.type;
    }

    @Nullable
    public Boolean getDurable() {
        return this.durable;
    }

    @Nullable
    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    @JsonProperty(value="name")
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @JsonProperty(value="type")
    public void setType(@Nullable AMQPChannelExchangeType type) {
        this.type = type;
    }

    @JsonProperty(value="durable")
    public void setDurable(@Nullable Boolean durable) {
        this.durable = durable;
    }

    @JsonProperty(value="autoDelete")
    public void setAutoDelete(@Nullable Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public String toString() {
        return "AMQPChannelExchangeProperties(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", durable=" + this.getDurable() + ", autoDelete=" + this.getAutoDelete() + ")";
    }

    public AMQPChannelExchangeProperties() {
    }

    public AMQPChannelExchangeProperties(@Nullable String name, @Nullable AMQPChannelExchangeType type, @Nullable Boolean durable, @Nullable Boolean autoDelete) {
        this.name = name;
        this.type = type;
        this.durable = durable;
        this.autoDelete = autoDelete;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AMQPChannelExchangeProperties)) {
            return false;
        }
        AMQPChannelExchangeProperties other = (AMQPChannelExchangeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$durable = this.getDurable();
        Boolean other$durable = other.getDurable();
        if (this$durable == null ? other$durable != null : !((Object)this$durable).equals(other$durable)) {
            return false;
        }
        Boolean this$autoDelete = this.getAutoDelete();
        Boolean other$autoDelete = other.getAutoDelete();
        if (this$autoDelete == null ? other$autoDelete != null : !((Object)this$autoDelete).equals(other$autoDelete)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AMQPChannelExchangeType this$type = this.getType();
        AMQPChannelExchangeType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AMQPChannelExchangeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $durable = this.getDurable();
        result = result * 59 + ($durable == null ? 43 : ((Object)$durable).hashCode());
        Boolean $autoDelete = this.getAutoDelete();
        result = result * 59 + ($autoDelete == null ? 43 : ((Object)$autoDelete).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AMQPChannelExchangeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static class AMQPChannelExchangePropertiesBuilder {
        private String name;
        private AMQPChannelExchangeType type;
        private Boolean durable;
        private Boolean autoDelete;

        AMQPChannelExchangePropertiesBuilder() {
        }

        @JsonProperty(value="name")
        public AMQPChannelExchangePropertiesBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public AMQPChannelExchangePropertiesBuilder type(@Nullable AMQPChannelExchangeType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="durable")
        public AMQPChannelExchangePropertiesBuilder durable(@Nullable Boolean durable) {
            this.durable = durable;
            return this;
        }

        @JsonProperty(value="autoDelete")
        public AMQPChannelExchangePropertiesBuilder autoDelete(@Nullable Boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public AMQPChannelExchangeProperties build() {
            return new AMQPChannelExchangeProperties(this.name, this.type, this.durable, this.autoDelete);
        }

        public String toString() {
            return "AMQPChannelExchangeProperties.AMQPChannelExchangePropertiesBuilder(name=" + this.name + ", type=" + (Object)((Object)this.type) + ", durable=" + this.durable + ", autoDelete=" + this.autoDelete + ")";
        }
    }
}

