/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.ibmmq.v0._1_0.message;

import com.asyncapi.bindings.ibmmq.v0._1_0.message.IBMMQMessageType;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes IBM MQ message binding.")
public class IBMMQMessageBinding
extends com.asyncapi.bindings.ibmmq.IBMMQMessageBinding {
    @JsonProperty(value="type", defaultValue="string")
    @JsonPropertyDescription(value="The type of the message.")
    @Nullable
    private IBMMQMessageType type;
    @JsonProperty(value="headers")
    @JsonPropertyDescription(value="Defines the IBM MQ message headers to include with this message. More than one header can be specified as a comma separated list.")
    @Nullable
    private String headers;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Provides additional information for application developers: describes the message type or format.")
    @Nullable
    private String description;
    @Min(value=0L, message="Expiry must be greater or equals to 0")
    @JsonProperty(value="expiry", defaultValue="0")
    @JsonPropertyDescription(value="The recommended setting the client should use for the TTL (Time-To-Live) of the message. This is a period of time expressed in milliseconds and set by the application that puts the message. 'expiry' values are API dependant e.g., MQI and JMS use different units of time and default values for 'unlimited'. General information on IBM MQ message expiry can be found on this [page](https://www.ibm.com/docs/en/ibm-mq/9.2?topic=mqmd-expiry-mqlong) in the IBM MQ Knowledge Center.")
    @Nullable
    private @Min(value=0L, message="Expiry must be greater or equals to 0") @Nullable Integer expiry;

    @Override
    public String getBindingVersion() {
        return "0.1.0";
    }

    @Override
    public void setBindingVersion(@Nullable String bindingVersion) {
        super.setBindingVersion("0.1.0");
    }

    private static IBMMQMessageType $default$type() {
        return IBMMQMessageType.STRING;
    }

    private static Integer $default$expiry() {
        return 0;
    }

    public static IBMMQMessageBindingBuilder builder() {
        return new IBMMQMessageBindingBuilder();
    }

    @Nullable
    public IBMMQMessageType getType() {
        return this.type;
    }

    @Nullable
    public String getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getExpiry() {
        return this.expiry;
    }

    @JsonProperty(value="type", defaultValue="string")
    public void setType(@Nullable IBMMQMessageType type) {
        this.type = type;
    }

    @JsonProperty(value="headers")
    public void setHeaders(@Nullable String headers) {
        this.headers = headers;
    }

    @JsonProperty(value="description")
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @JsonProperty(value="expiry", defaultValue="0")
    public void setExpiry(@Nullable Integer expiry) {
        this.expiry = expiry;
    }

    @Override
    public String toString() {
        return "IBMMQMessageBinding(type=" + (Object)((Object)this.getType()) + ", headers=" + this.getHeaders() + ", description=" + this.getDescription() + ", expiry=" + this.getExpiry() + ")";
    }

    public IBMMQMessageBinding() {
        this.type = IBMMQMessageBinding.$default$type();
        this.expiry = IBMMQMessageBinding.$default$expiry();
    }

    public IBMMQMessageBinding(@Nullable IBMMQMessageType type, @Nullable String headers, @Nullable String description, @Nullable Integer expiry) {
        this.type = type;
        this.headers = headers;
        this.description = description;
        this.expiry = expiry;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IBMMQMessageBinding)) {
            return false;
        }
        IBMMQMessageBinding other = (IBMMQMessageBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$expiry = this.getExpiry();
        Integer other$expiry = other.getExpiry();
        if (this$expiry == null ? other$expiry != null : !((Object)this$expiry).equals(other$expiry)) {
            return false;
        }
        IBMMQMessageType this$type = this.getType();
        IBMMQMessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$headers = this.getHeaders();
        String other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IBMMQMessageBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $expiry = this.getExpiry();
        result = result * 59 + ($expiry == null ? 43 : ((Object)$expiry).hashCode());
        IBMMQMessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static class IBMMQMessageBindingBuilder {
        private boolean type$set;
        private IBMMQMessageType type$value;
        private String headers;
        private String description;
        private boolean expiry$set;
        private Integer expiry$value;

        IBMMQMessageBindingBuilder() {
        }

        @JsonProperty(value="type", defaultValue="string")
        public IBMMQMessageBindingBuilder type(@Nullable IBMMQMessageType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @JsonProperty(value="headers")
        public IBMMQMessageBindingBuilder headers(@Nullable String headers) {
            this.headers = headers;
            return this;
        }

        @JsonProperty(value="description")
        public IBMMQMessageBindingBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="expiry", defaultValue="0")
        public IBMMQMessageBindingBuilder expiry(@Nullable Integer expiry) {
            this.expiry$value = expiry;
            this.expiry$set = true;
            return this;
        }

        public IBMMQMessageBinding build() {
            IBMMQMessageType type$value = this.type$value;
            if (!this.type$set) {
                type$value = IBMMQMessageBinding.$default$type();
            }
            Integer expiry$value = this.expiry$value;
            if (!this.expiry$set) {
                expiry$value = IBMMQMessageBinding.$default$expiry();
            }
            return new IBMMQMessageBinding(type$value, this.headers, this.description, expiry$value);
        }

        public String toString() {
            return "IBMMQMessageBinding.IBMMQMessageBindingBuilder(type$value=" + (Object)((Object)this.type$value) + ", headers=" + this.headers + ", description=" + this.description + ", expiry$value=" + this.expiry$value + ")";
        }
    }
}

