/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.kafka.v0._4_0.channel;

import com.asyncapi.bindings.kafka.v0._4_0.channel.KafkaChannelTopicCleanupPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

public class KafkaChannelTopicConfiguration {
    @JsonProperty(value="cleanup.policy")
    @Nullable
    private List<KafkaChannelTopicCleanupPolicy> cleanupPolicy;
    @Min(value=-1L, message="retention.ms must be greater or equals to -1")
    @JsonProperty(value="retention.ms")
    @JsonPropertyDescription(value="The [`retention.ms`](https://kafka.apache.org/documentation/#topicconfigs_retention.ms) configuration option.")
    @Nullable
    private @Min(value=-1L, message="retention.ms must be greater or equals to -1") @Nullable Integer retentionMs;
    @Min(value=-1L, message="retention.bytes must be greater or equals to -1")
    @JsonProperty(value="retention.bytes")
    @JsonPropertyDescription(value="The [`retention.bytes`](https://kafka.apache.org/documentation/#topicconfigs_retention.bytes) configuration option.")
    @Nullable
    private @Min(value=-1L, message="retention.bytes must be greater or equals to -1") @Nullable Integer retentionBytes;
    @Min(value=0L, message="delete.retention.ms must be greater or equals to 0")
    @JsonProperty(value="delete.retention.ms")
    @JsonPropertyDescription(value="The [`delete.retention.ms`](https://kafka.apache.org/documentation/#topicconfigs_delete.retention.ms) configuration option.")
    @Nullable
    private @Min(value=0L, message="delete.retention.ms must be greater or equals to 0") @Nullable Integer deleteRetentionMs;
    @Min(value=0L, message="max.message.bytes must be greater or equals to 0")
    @JsonProperty(value="max.message.bytes")
    @JsonPropertyDescription(value="The [`max.message.bytes`](https://kafka.apache.org/documentation/#topicconfigs_max.message.bytes) configuration option.")
    @Nullable
    private @Min(value=0L, message="max.message.bytes must be greater or equals to 0") @Nullable Integer maxMessageBytes;

    public static KafkaChannelTopicConfigurationBuilder builder() {
        return new KafkaChannelTopicConfigurationBuilder();
    }

    @Nullable
    public List<KafkaChannelTopicCleanupPolicy> getCleanupPolicy() {
        return this.cleanupPolicy;
    }

    @Nullable
    public Integer getRetentionMs() {
        return this.retentionMs;
    }

    @Nullable
    public Integer getRetentionBytes() {
        return this.retentionBytes;
    }

    @Nullable
    public Integer getDeleteRetentionMs() {
        return this.deleteRetentionMs;
    }

    @Nullable
    public Integer getMaxMessageBytes() {
        return this.maxMessageBytes;
    }

    @JsonProperty(value="cleanup.policy")
    public void setCleanupPolicy(@Nullable List<KafkaChannelTopicCleanupPolicy> cleanupPolicy) {
        this.cleanupPolicy = cleanupPolicy;
    }

    @JsonProperty(value="retention.ms")
    public void setRetentionMs(@Nullable Integer retentionMs) {
        this.retentionMs = retentionMs;
    }

    @JsonProperty(value="retention.bytes")
    public void setRetentionBytes(@Nullable Integer retentionBytes) {
        this.retentionBytes = retentionBytes;
    }

    @JsonProperty(value="delete.retention.ms")
    public void setDeleteRetentionMs(@Nullable Integer deleteRetentionMs) {
        this.deleteRetentionMs = deleteRetentionMs;
    }

    @JsonProperty(value="max.message.bytes")
    public void setMaxMessageBytes(@Nullable Integer maxMessageBytes) {
        this.maxMessageBytes = maxMessageBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaChannelTopicConfiguration)) {
            return false;
        }
        KafkaChannelTopicConfiguration other = (KafkaChannelTopicConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$retentionMs = this.getRetentionMs();
        Integer other$retentionMs = other.getRetentionMs();
        if (this$retentionMs == null ? other$retentionMs != null : !((Object)this$retentionMs).equals(other$retentionMs)) {
            return false;
        }
        Integer this$retentionBytes = this.getRetentionBytes();
        Integer other$retentionBytes = other.getRetentionBytes();
        if (this$retentionBytes == null ? other$retentionBytes != null : !((Object)this$retentionBytes).equals(other$retentionBytes)) {
            return false;
        }
        Integer this$deleteRetentionMs = this.getDeleteRetentionMs();
        Integer other$deleteRetentionMs = other.getDeleteRetentionMs();
        if (this$deleteRetentionMs == null ? other$deleteRetentionMs != null : !((Object)this$deleteRetentionMs).equals(other$deleteRetentionMs)) {
            return false;
        }
        Integer this$maxMessageBytes = this.getMaxMessageBytes();
        Integer other$maxMessageBytes = other.getMaxMessageBytes();
        if (this$maxMessageBytes == null ? other$maxMessageBytes != null : !((Object)this$maxMessageBytes).equals(other$maxMessageBytes)) {
            return false;
        }
        List<KafkaChannelTopicCleanupPolicy> this$cleanupPolicy = this.getCleanupPolicy();
        List<KafkaChannelTopicCleanupPolicy> other$cleanupPolicy = other.getCleanupPolicy();
        return !(this$cleanupPolicy == null ? other$cleanupPolicy != null : !((Object)this$cleanupPolicy).equals(other$cleanupPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaChannelTopicConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $retentionMs = this.getRetentionMs();
        result = result * 59 + ($retentionMs == null ? 43 : ((Object)$retentionMs).hashCode());
        Integer $retentionBytes = this.getRetentionBytes();
        result = result * 59 + ($retentionBytes == null ? 43 : ((Object)$retentionBytes).hashCode());
        Integer $deleteRetentionMs = this.getDeleteRetentionMs();
        result = result * 59 + ($deleteRetentionMs == null ? 43 : ((Object)$deleteRetentionMs).hashCode());
        Integer $maxMessageBytes = this.getMaxMessageBytes();
        result = result * 59 + ($maxMessageBytes == null ? 43 : ((Object)$maxMessageBytes).hashCode());
        List<KafkaChannelTopicCleanupPolicy> $cleanupPolicy = this.getCleanupPolicy();
        result = result * 59 + ($cleanupPolicy == null ? 43 : ((Object)$cleanupPolicy).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaChannelTopicConfiguration(cleanupPolicy=" + this.getCleanupPolicy() + ", retentionMs=" + this.getRetentionMs() + ", retentionBytes=" + this.getRetentionBytes() + ", deleteRetentionMs=" + this.getDeleteRetentionMs() + ", maxMessageBytes=" + this.getMaxMessageBytes() + ")";
    }

    public KafkaChannelTopicConfiguration() {
    }

    public KafkaChannelTopicConfiguration(@Nullable List<KafkaChannelTopicCleanupPolicy> cleanupPolicy, @Nullable Integer retentionMs, @Nullable Integer retentionBytes, @Nullable Integer deleteRetentionMs, @Nullable Integer maxMessageBytes) {
        this.cleanupPolicy = cleanupPolicy;
        this.retentionMs = retentionMs;
        this.retentionBytes = retentionBytes;
        this.deleteRetentionMs = deleteRetentionMs;
        this.maxMessageBytes = maxMessageBytes;
    }

    public static class KafkaChannelTopicConfigurationBuilder {
        private List<KafkaChannelTopicCleanupPolicy> cleanupPolicy;
        private Integer retentionMs;
        private Integer retentionBytes;
        private Integer deleteRetentionMs;
        private Integer maxMessageBytes;

        KafkaChannelTopicConfigurationBuilder() {
        }

        @JsonProperty(value="cleanup.policy")
        public KafkaChannelTopicConfigurationBuilder cleanupPolicy(@Nullable List<KafkaChannelTopicCleanupPolicy> cleanupPolicy) {
            this.cleanupPolicy = cleanupPolicy;
            return this;
        }

        @JsonProperty(value="retention.ms")
        public KafkaChannelTopicConfigurationBuilder retentionMs(@Nullable Integer retentionMs) {
            this.retentionMs = retentionMs;
            return this;
        }

        @JsonProperty(value="retention.bytes")
        public KafkaChannelTopicConfigurationBuilder retentionBytes(@Nullable Integer retentionBytes) {
            this.retentionBytes = retentionBytes;
            return this;
        }

        @JsonProperty(value="delete.retention.ms")
        public KafkaChannelTopicConfigurationBuilder deleteRetentionMs(@Nullable Integer deleteRetentionMs) {
            this.deleteRetentionMs = deleteRetentionMs;
            return this;
        }

        @JsonProperty(value="max.message.bytes")
        public KafkaChannelTopicConfigurationBuilder maxMessageBytes(@Nullable Integer maxMessageBytes) {
            this.maxMessageBytes = maxMessageBytes;
            return this;
        }

        public KafkaChannelTopicConfiguration build() {
            return new KafkaChannelTopicConfiguration(this.cleanupPolicy, this.retentionMs, this.retentionBytes, this.deleteRetentionMs, this.maxMessageBytes);
        }

        public String toString() {
            return "KafkaChannelTopicConfiguration.KafkaChannelTopicConfigurationBuilder(cleanupPolicy=" + this.cleanupPolicy + ", retentionMs=" + this.retentionMs + ", retentionBytes=" + this.retentionBytes + ", deleteRetentionMs=" + this.deleteRetentionMs + ", maxMessageBytes=" + this.maxMessageBytes + ")";
        }
    }
}

