/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.kafka.v0._5_0.channel;

import com.asyncapi.bindings.kafka.v0._5_0.channel.KafkaChannelTopicConfiguration;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes Kafka channel binding.")
public class KafkaChannelBinding
extends com.asyncapi.bindings.kafka.KafkaChannelBinding {
    @JsonProperty(value="topic")
    @JsonPropertyDescription(value="Kafka topic name if different from channel name.")
    @Nullable
    private String topic;
    @Min(value=1L, message="Number of partitions must be greater or equals to 1")
    @JsonProperty(value="partitions")
    @JsonPropertyDescription(value="Number of partitions configured on this topic (useful to know how many parallel consumers you may run).")
    @Nullable
    private @Min(value=1L, message="Number of partitions must be greater or equals to 1") @Nullable Integer partitions;
    @Min(value=1L, message="Number of replicas must be greater or equals to 1")
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="Number of replicas configured on this topic.")
    @Nullable
    private @Min(value=1L, message="Number of replicas must be greater or equals to 1") @Nullable Integer replicas;
    @JsonProperty(value="topicConfiguration")
    @JsonPropertyDescription(value="Topic configuration properties that are relevant for the API.")
    @Nullable
    private KafkaChannelTopicConfiguration topicConfiguration;

    @Override
    public String getBindingVersion() {
        return "0.5.0";
    }

    @Override
    public void setBindingVersion(@Nullable String bindingVersion) {
        super.setBindingVersion("0.5.0");
    }

    public static KafkaChannelBindingBuilder builder() {
        return new KafkaChannelBindingBuilder();
    }

    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @Nullable
    public Integer getPartitions() {
        return this.partitions;
    }

    @Nullable
    public Integer getReplicas() {
        return this.replicas;
    }

    @Nullable
    public KafkaChannelTopicConfiguration getTopicConfiguration() {
        return this.topicConfiguration;
    }

    @JsonProperty(value="topic")
    public void setTopic(@Nullable String topic) {
        this.topic = topic;
    }

    @JsonProperty(value="partitions")
    public void setPartitions(@Nullable Integer partitions) {
        this.partitions = partitions;
    }

    @JsonProperty(value="replicas")
    public void setReplicas(@Nullable Integer replicas) {
        this.replicas = replicas;
    }

    @JsonProperty(value="topicConfiguration")
    public void setTopicConfiguration(@Nullable KafkaChannelTopicConfiguration topicConfiguration) {
        this.topicConfiguration = topicConfiguration;
    }

    @Override
    public String toString() {
        return "KafkaChannelBinding(topic=" + this.getTopic() + ", partitions=" + this.getPartitions() + ", replicas=" + this.getReplicas() + ", topicConfiguration=" + this.getTopicConfiguration() + ")";
    }

    public KafkaChannelBinding() {
    }

    public KafkaChannelBinding(@Nullable String topic, @Nullable Integer partitions, @Nullable Integer replicas, @Nullable KafkaChannelTopicConfiguration topicConfiguration) {
        this.topic = topic;
        this.partitions = partitions;
        this.replicas = replicas;
        this.topicConfiguration = topicConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaChannelBinding)) {
            return false;
        }
        KafkaChannelBinding other = (KafkaChannelBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitions = this.getPartitions();
        Integer other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        KafkaChannelTopicConfiguration this$topicConfiguration = this.getTopicConfiguration();
        KafkaChannelTopicConfiguration other$topicConfiguration = other.getTopicConfiguration();
        return !(this$topicConfiguration == null ? other$topicConfiguration != null : !((Object)this$topicConfiguration).equals(other$topicConfiguration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaChannelBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        KafkaChannelTopicConfiguration $topicConfiguration = this.getTopicConfiguration();
        result = result * 59 + ($topicConfiguration == null ? 43 : ((Object)$topicConfiguration).hashCode());
        return result;
    }

    public static class KafkaChannelBindingBuilder {
        private String topic;
        private Integer partitions;
        private Integer replicas;
        private KafkaChannelTopicConfiguration topicConfiguration;

        KafkaChannelBindingBuilder() {
        }

        @JsonProperty(value="topic")
        public KafkaChannelBindingBuilder topic(@Nullable String topic) {
            this.topic = topic;
            return this;
        }

        @JsonProperty(value="partitions")
        public KafkaChannelBindingBuilder partitions(@Nullable Integer partitions) {
            this.partitions = partitions;
            return this;
        }

        @JsonProperty(value="replicas")
        public KafkaChannelBindingBuilder replicas(@Nullable Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @JsonProperty(value="topicConfiguration")
        public KafkaChannelBindingBuilder topicConfiguration(@Nullable KafkaChannelTopicConfiguration topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
            return this;
        }

        public KafkaChannelBinding build() {
            return new KafkaChannelBinding(this.topic, this.partitions, this.replicas, this.topicConfiguration);
        }

        public String toString() {
            return "KafkaChannelBinding.KafkaChannelBindingBuilder(topic=" + this.topic + ", partitions=" + this.partitions + ", replicas=" + this.replicas + ", topicConfiguration=" + this.topicConfiguration + ")";
        }
    }
}

