/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.mqtt.v0._2_0.operation;

import com.asyncapi.schemas.serde.asyncapi.ReferenceOrAsyncAPISchemaOrNumberDeserializer;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes MQTT operation binding.")
public class MQTTOperationBinding
extends com.asyncapi.bindings.mqtt.MQTTOperationBinding {
    @Min(value=0L, message="QoS must be greater or equals to 0.")
    @Max(value=2L, message="QoS must be lower or equals to 2.")
    @JsonProperty(value="qos")
    @JsonPropertyDescription(value="Defines the Quality of Service (QoS) levels for the message flow between client and server. Its value MUST be either 0 (At most once delivery), 1 (At least once delivery), or 2 (Exactly once delivery).")
    @Nullable
    private @Min(value=0L, message="QoS must be greater or equals to 0.") @Max(value=2L, message="QoS must be lower or equals to 2.") @Nullable Integer qos;
    @JsonProperty(value="retain")
    @JsonPropertyDescription(value="Whether the broker should retain the message or not.")
    @Nullable
    private Boolean retain;
    @JsonDeserialize(using=ReferenceOrAsyncAPISchemaOrNumberDeserializer.class)
    @Nullable
    private Object messageExpiryInterval;

    @Override
    public String getBindingVersion() {
        return "0.2.0";
    }

    @Override
    public void setBindingVersion(@Nullable String bindingVersion) {
        super.setBindingVersion("0.2.0");
    }

    public static MQTTOperationBindingBuilder builder() {
        return new MQTTOperationBindingBuilder();
    }

    @Nullable
    public Integer getQos() {
        return this.qos;
    }

    @Nullable
    public Boolean getRetain() {
        return this.retain;
    }

    @Nullable
    public Object getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    @JsonProperty(value="qos")
    public void setQos(@Nullable Integer qos) {
        this.qos = qos;
    }

    @JsonProperty(value="retain")
    public void setRetain(@Nullable Boolean retain) {
        this.retain = retain;
    }

    @JsonDeserialize(using=ReferenceOrAsyncAPISchemaOrNumberDeserializer.class)
    public void setMessageExpiryInterval(@Nullable Object messageExpiryInterval) {
        this.messageExpiryInterval = messageExpiryInterval;
    }

    @Override
    public String toString() {
        return "MQTTOperationBinding(qos=" + this.getQos() + ", retain=" + this.getRetain() + ", messageExpiryInterval=" + this.getMessageExpiryInterval() + ")";
    }

    public MQTTOperationBinding() {
    }

    public MQTTOperationBinding(@Nullable Integer qos, @Nullable Boolean retain, @Nullable Object messageExpiryInterval) {
        this.qos = qos;
        this.retain = retain;
        this.messageExpiryInterval = messageExpiryInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MQTTOperationBinding)) {
            return false;
        }
        MQTTOperationBinding other = (MQTTOperationBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$qos = this.getQos();
        Integer other$qos = other.getQos();
        if (this$qos == null ? other$qos != null : !((Object)this$qos).equals(other$qos)) {
            return false;
        }
        Boolean this$retain = this.getRetain();
        Boolean other$retain = other.getRetain();
        if (this$retain == null ? other$retain != null : !((Object)this$retain).equals(other$retain)) {
            return false;
        }
        Object this$messageExpiryInterval = this.getMessageExpiryInterval();
        Object other$messageExpiryInterval = other.getMessageExpiryInterval();
        return !(this$messageExpiryInterval == null ? other$messageExpiryInterval != null : !this$messageExpiryInterval.equals(other$messageExpiryInterval));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MQTTOperationBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $qos = this.getQos();
        result = result * 59 + ($qos == null ? 43 : ((Object)$qos).hashCode());
        Boolean $retain = this.getRetain();
        result = result * 59 + ($retain == null ? 43 : ((Object)$retain).hashCode());
        Object $messageExpiryInterval = this.getMessageExpiryInterval();
        result = result * 59 + ($messageExpiryInterval == null ? 43 : $messageExpiryInterval.hashCode());
        return result;
    }

    public static class MQTTOperationBindingBuilder {
        private Integer qos;
        private Boolean retain;
        private Object messageExpiryInterval;

        MQTTOperationBindingBuilder() {
        }

        @JsonProperty(value="qos")
        public MQTTOperationBindingBuilder qos(@Nullable Integer qos) {
            this.qos = qos;
            return this;
        }

        @JsonProperty(value="retain")
        public MQTTOperationBindingBuilder retain(@Nullable Boolean retain) {
            this.retain = retain;
            return this;
        }

        @JsonDeserialize(using=ReferenceOrAsyncAPISchemaOrNumberDeserializer.class)
        public MQTTOperationBindingBuilder messageExpiryInterval(@Nullable Object messageExpiryInterval) {
            this.messageExpiryInterval = messageExpiryInterval;
            return this;
        }

        public MQTTOperationBinding build() {
            return new MQTTOperationBinding(this.qos, this.retain, this.messageExpiryInterval);
        }

        public String toString() {
            return "MQTTOperationBinding.MQTTOperationBindingBuilder(qos=" + this.qos + ", retain=" + this.retain + ", messageExpiryInterval=" + this.messageExpiryInterval + ")";
        }
    }
}

