/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.mqtt.v0._2_0.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

public class MQTTServerLastWillConfiguration {
    @JsonProperty(value="topic")
    @JsonPropertyDescription(value="The topic where the Last Will and Testament message will be sent.")
    @Nullable
    private String topic;
    @Min(value=0L, message="QoS must be greater or equals to 0.")
    @Max(value=2L, message="QoS must be lower or equals to 0.")
    @JsonProperty(value="qos")
    @JsonPropertyDescription(value="Defines how hard the broker/client will try to ensure that the Last Will and Testament message is received. Its value MUST be either 0, 1 or 2.")
    @Nullable
    private @Min(value=0L, message="QoS must be greater or equals to 0.") @Max(value=2L, message="QoS must be lower or equals to 0.") @Nullable Integer qos;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Last Will message.")
    @Nullable
    private String message;
    @JsonProperty(value="retain")
    @JsonPropertyDescription(value="Whether the broker should retain the Last Will and Testament message or not.")
    @Nullable
    private Boolean retain;

    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @Nullable
    public Integer getQos() {
        return this.qos;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Boolean getRetain() {
        return this.retain;
    }

    @JsonProperty(value="topic")
    public void setTopic(@Nullable String topic) {
        this.topic = topic;
    }

    @JsonProperty(value="qos")
    public void setQos(@Nullable Integer qos) {
        this.qos = qos;
    }

    @JsonProperty(value="message")
    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @JsonProperty(value="retain")
    public void setRetain(@Nullable Boolean retain) {
        this.retain = retain;
    }

    public String toString() {
        return "MQTTServerLastWillConfiguration(topic=" + this.getTopic() + ", qos=" + this.getQos() + ", message=" + this.getMessage() + ", retain=" + this.getRetain() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MQTTServerLastWillConfiguration)) {
            return false;
        }
        MQTTServerLastWillConfiguration other = (MQTTServerLastWillConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$qos = this.getQos();
        Integer other$qos = other.getQos();
        if (this$qos == null ? other$qos != null : !((Object)this$qos).equals(other$qos)) {
            return false;
        }
        Boolean this$retain = this.getRetain();
        Boolean other$retain = other.getRetain();
        if (this$retain == null ? other$retain != null : !((Object)this$retain).equals(other$retain)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MQTTServerLastWillConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $qos = this.getQos();
        result = result * 59 + ($qos == null ? 43 : ((Object)$qos).hashCode());
        Boolean $retain = this.getRetain();
        result = result * 59 + ($retain == null ? 43 : ((Object)$retain).hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public MQTTServerLastWillConfiguration() {
    }

    public MQTTServerLastWillConfiguration(@Nullable String topic, @Nullable Integer qos, @Nullable String message, @Nullable Boolean retain) {
        this.topic = topic;
        this.qos = qos;
        this.message = message;
        this.retain = retain;
    }
}

