/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.solace.v0._2_0.operation.queue;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes Solace queue.")
public class SolaceOperationQueue {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the queue, only applicable when destinationType is 'queue'.")
    @Nullable
    private String name;
    @JsonProperty(value="topicSubscriptions")
    @JsonPropertyDescription(value="A list of topics that the queue subscribes to, only applicable when destinationType is 'queue'. If none is given, the queue subscribes to the topic as represented by the channel name.")
    @Nullable
    private List<String> topicSubscriptions;
    @JsonProperty(value="accessType")
    @JsonPropertyDescription(value="'exclusive' or 'nonexclusive'. This is documented at https://docs.solace.com/Messaging/Guaranteed-Msg/Endpoints.htm#Queues. Only applicable when destinationType is 'queue'.")
    @Nullable
    private AccessType accessType;

    public static SolaceOperationQueueBuilder builder() {
        return new SolaceOperationQueueBuilder();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public List<String> getTopicSubscriptions() {
        return this.topicSubscriptions;
    }

    @Nullable
    public AccessType getAccessType() {
        return this.accessType;
    }

    @JsonProperty(value="name")
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @JsonProperty(value="topicSubscriptions")
    public void setTopicSubscriptions(@Nullable List<String> topicSubscriptions) {
        this.topicSubscriptions = topicSubscriptions;
    }

    @JsonProperty(value="accessType")
    public void setAccessType(@Nullable AccessType accessType) {
        this.accessType = accessType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolaceOperationQueue)) {
            return false;
        }
        SolaceOperationQueue other = (SolaceOperationQueue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$topicSubscriptions = this.getTopicSubscriptions();
        List<String> other$topicSubscriptions = other.getTopicSubscriptions();
        if (this$topicSubscriptions == null ? other$topicSubscriptions != null : !((Object)this$topicSubscriptions).equals(other$topicSubscriptions)) {
            return false;
        }
        AccessType this$accessType = this.getAccessType();
        AccessType other$accessType = other.getAccessType();
        return !(this$accessType == null ? other$accessType != null : !((Object)((Object)this$accessType)).equals((Object)other$accessType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolaceOperationQueue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $topicSubscriptions = this.getTopicSubscriptions();
        result = result * 59 + ($topicSubscriptions == null ? 43 : ((Object)$topicSubscriptions).hashCode());
        AccessType $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : ((Object)((Object)$accessType)).hashCode());
        return result;
    }

    public String toString() {
        return "SolaceOperationQueue(name=" + this.getName() + ", topicSubscriptions=" + this.getTopicSubscriptions() + ", accessType=" + (Object)((Object)this.getAccessType()) + ")";
    }

    public SolaceOperationQueue() {
    }

    public SolaceOperationQueue(@Nullable String name, @Nullable List<String> topicSubscriptions, @Nullable AccessType accessType) {
        this.name = name;
        this.topicSubscriptions = topicSubscriptions;
        this.accessType = accessType;
    }

    public static class SolaceOperationQueueBuilder {
        private String name;
        private List<String> topicSubscriptions;
        private AccessType accessType;

        SolaceOperationQueueBuilder() {
        }

        @JsonProperty(value="name")
        public SolaceOperationQueueBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="topicSubscriptions")
        public SolaceOperationQueueBuilder topicSubscriptions(@Nullable List<String> topicSubscriptions) {
            this.topicSubscriptions = topicSubscriptions;
            return this;
        }

        @JsonProperty(value="accessType")
        public SolaceOperationQueueBuilder accessType(@Nullable AccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public SolaceOperationQueue build() {
            return new SolaceOperationQueue(this.name, this.topicSubscriptions, this.accessType);
        }

        public String toString() {
            return "SolaceOperationQueue.SolaceOperationQueueBuilder(name=" + this.name + ", topicSubscriptions=" + this.topicSubscriptions + ", accessType=" + (Object)((Object)this.accessType) + ")";
        }
    }

    public static enum AccessType {
        EXCLUSIVE,
        NON_EXCLUSIVE;

    }
}

