/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.asyncapi.security.v2;

import com.asyncapi.schemas.asyncapi.security.v2.SecurityScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenIdConnectSecurityScheme
extends SecurityScheme {
    @NotNull
    private String openIdConnectUrl = "";

    public OpenIdConnectSecurityScheme(@Nullable String description, @NotNull String openIdConnectUrl) {
        super(SecurityScheme.Type.OPENID_CONNECT, description);
        this.openIdConnectUrl = openIdConnectUrl;
    }

    public static OpenIdConnectSecuritySchemeBuilder openIdBuilder() {
        return new OpenIdConnectSecuritySchemeBuilder();
    }

    @NotNull
    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public void setOpenIdConnectUrl(@NotNull String openIdConnectUrl) {
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    public String toString() {
        return "OpenIdConnectSecurityScheme(openIdConnectUrl=" + this.getOpenIdConnectUrl() + ")";
    }

    public OpenIdConnectSecurityScheme() {
    }

    public OpenIdConnectSecurityScheme(@NotNull String openIdConnectUrl) {
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenIdConnectSecurityScheme)) {
            return false;
        }
        OpenIdConnectSecurityScheme other = (OpenIdConnectSecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$openIdConnectUrl = this.getOpenIdConnectUrl();
        String other$openIdConnectUrl = other.getOpenIdConnectUrl();
        return !(this$openIdConnectUrl == null ? other$openIdConnectUrl != null : !this$openIdConnectUrl.equals(other$openIdConnectUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OpenIdConnectSecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $openIdConnectUrl = this.getOpenIdConnectUrl();
        result = result * 59 + ($openIdConnectUrl == null ? 43 : $openIdConnectUrl.hashCode());
        return result;
    }

    public static class OpenIdConnectSecuritySchemeBuilder {
        private String description;
        private String openIdConnectUrl;

        OpenIdConnectSecuritySchemeBuilder() {
        }

        public OpenIdConnectSecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OpenIdConnectSecuritySchemeBuilder openIdConnectUrl(@NotNull String openIdConnectUrl) {
            if (openIdConnectUrl == null) {
                throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
            }
            this.openIdConnectUrl = openIdConnectUrl;
            return this;
        }

        public OpenIdConnectSecurityScheme build() {
            return new OpenIdConnectSecurityScheme(this.description, this.openIdConnectUrl);
        }

        public String toString() {
            return "OpenIdConnectSecurityScheme.OpenIdConnectSecuritySchemeBuilder(description=" + this.description + ", openIdConnectUrl=" + this.openIdConnectUrl + ")";
        }
    }
}

