/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.ibmmq.v0._1_0.server;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes IBM MQ server binding.")
public class IBMMQServerBinding
extends com.asyncapi.bindings.ibmmq.IBMMQServerBinding {
    @JsonProperty(value="groupId")
    @JsonPropertyDescription(value="Defines a logical group of IBM MQ server objects. This is necessary to specify multi-endpoint configurations used in high availability deployments. If omitted, the server object is not part of a group.")
    @Nullable
    private String groupId;
    @JsonProperty(value="ccdtQueueManagerName", defaultValue="*")
    @JsonPropertyDescription(value="The name of the IBM MQ queue manager to bind to in the CCDT file.")
    @Nullable
    private String ccdtQueueManagerName;
    @JsonProperty(value="cipherSpec", defaultValue="ANY")
    @JsonPropertyDescription(value="The recommended cipher specification used to establish a TLS connection between the client and the IBM MQ queue manager. More information on SSL/TLS cipher specifications supported by IBM MQ can be found on this page in the IBM MQ Knowledge Center.")
    @Nullable
    private String cipherSpec;
    @JsonProperty(value="multiEndpointServer", defaultValue="false")
    @JsonPropertyDescription(value="If multiEndpointServer is true then multiple connections can be workload balanced and applications should not make assumptions as to where messages are processed. Where message ordering, or affinity to specific message resources is necessary, a single endpoint (multiEndpointServer = false) may be required. MUST NOT be specified for URI Scheme file:// or http://")
    private Boolean multiEndpointServer;
    @Min(value=0L, message="Heart beat interval must be greater or equals to 0")
    @Max(value=999999L, message="Heart beat interval must be less or equals to 999999")
    @JsonProperty(value="heartBeatInterval", defaultValue="300")
    @JsonPropertyDescription(value="The recommended value (in seconds) for the heartbeat sent to the queue manager during periods of inactivity. A value of zero means that no heart beats are sent. A value of 1 means that the client will use the value defined by the queue manager.")
    private @Min(value=0L, message="Heart beat interval must be greater or equals to 0") @Max(value=999999L, message="Heart beat interval must be less or equals to 999999") int heartBeatInterval;

    @Override
    public String getBindingVersion() {
        return "0.1.0";
    }

    @Override
    public void setBindingVersion(@Nullable String bindingVersion) {
        super.setBindingVersion("0.1.0");
    }

    private static String $default$ccdtQueueManagerName() {
        return "*";
    }

    private static String $default$cipherSpec() {
        return "ANY";
    }

    private static Boolean $default$multiEndpointServer() {
        return false;
    }

    private static int $default$heartBeatInterval() {
        return 300;
    }

    public static IBMMQServerBindingBuilder builder() {
        return new IBMMQServerBindingBuilder();
    }

    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getCcdtQueueManagerName() {
        return this.ccdtQueueManagerName;
    }

    @Nullable
    public String getCipherSpec() {
        return this.cipherSpec;
    }

    public Boolean getMultiEndpointServer() {
        return this.multiEndpointServer;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @JsonProperty(value="groupId")
    public void setGroupId(@Nullable String groupId) {
        this.groupId = groupId;
    }

    @JsonProperty(value="ccdtQueueManagerName", defaultValue="*")
    public void setCcdtQueueManagerName(@Nullable String ccdtQueueManagerName) {
        this.ccdtQueueManagerName = ccdtQueueManagerName;
    }

    @JsonProperty(value="cipherSpec", defaultValue="ANY")
    public void setCipherSpec(@Nullable String cipherSpec) {
        this.cipherSpec = cipherSpec;
    }

    @JsonProperty(value="multiEndpointServer", defaultValue="false")
    public void setMultiEndpointServer(Boolean multiEndpointServer) {
        this.multiEndpointServer = multiEndpointServer;
    }

    @JsonProperty(value="heartBeatInterval", defaultValue="300")
    public void setHeartBeatInterval(int heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    @Override
    public String toString() {
        return "IBMMQServerBinding(groupId=" + this.getGroupId() + ", ccdtQueueManagerName=" + this.getCcdtQueueManagerName() + ", cipherSpec=" + this.getCipherSpec() + ", multiEndpointServer=" + this.getMultiEndpointServer() + ", heartBeatInterval=" + this.getHeartBeatInterval() + ")";
    }

    public IBMMQServerBinding() {
        this.ccdtQueueManagerName = IBMMQServerBinding.$default$ccdtQueueManagerName();
        this.cipherSpec = IBMMQServerBinding.$default$cipherSpec();
        this.multiEndpointServer = IBMMQServerBinding.$default$multiEndpointServer();
        this.heartBeatInterval = IBMMQServerBinding.$default$heartBeatInterval();
    }

    public IBMMQServerBinding(@Nullable String groupId, @Nullable String ccdtQueueManagerName, @Nullable String cipherSpec, Boolean multiEndpointServer, int heartBeatInterval) {
        this.groupId = groupId;
        this.ccdtQueueManagerName = ccdtQueueManagerName;
        this.cipherSpec = cipherSpec;
        this.multiEndpointServer = multiEndpointServer;
        this.heartBeatInterval = heartBeatInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IBMMQServerBinding)) {
            return false;
        }
        IBMMQServerBinding other = (IBMMQServerBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHeartBeatInterval() != other.getHeartBeatInterval()) {
            return false;
        }
        Boolean this$multiEndpointServer = this.getMultiEndpointServer();
        Boolean other$multiEndpointServer = other.getMultiEndpointServer();
        if (this$multiEndpointServer == null ? other$multiEndpointServer != null : !((Object)this$multiEndpointServer).equals(other$multiEndpointServer)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$ccdtQueueManagerName = this.getCcdtQueueManagerName();
        String other$ccdtQueueManagerName = other.getCcdtQueueManagerName();
        if (this$ccdtQueueManagerName == null ? other$ccdtQueueManagerName != null : !this$ccdtQueueManagerName.equals(other$ccdtQueueManagerName)) {
            return false;
        }
        String this$cipherSpec = this.getCipherSpec();
        String other$cipherSpec = other.getCipherSpec();
        return !(this$cipherSpec == null ? other$cipherSpec != null : !this$cipherSpec.equals(other$cipherSpec));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IBMMQServerBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHeartBeatInterval();
        Boolean $multiEndpointServer = this.getMultiEndpointServer();
        result = result * 59 + ($multiEndpointServer == null ? 43 : ((Object)$multiEndpointServer).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $ccdtQueueManagerName = this.getCcdtQueueManagerName();
        result = result * 59 + ($ccdtQueueManagerName == null ? 43 : $ccdtQueueManagerName.hashCode());
        String $cipherSpec = this.getCipherSpec();
        result = result * 59 + ($cipherSpec == null ? 43 : $cipherSpec.hashCode());
        return result;
    }

    public static class IBMMQServerBindingBuilder {
        private String groupId;
        private boolean ccdtQueueManagerName$set;
        private String ccdtQueueManagerName$value;
        private boolean cipherSpec$set;
        private String cipherSpec$value;
        private boolean multiEndpointServer$set;
        private Boolean multiEndpointServer$value;
        private boolean heartBeatInterval$set;
        private int heartBeatInterval$value;

        IBMMQServerBindingBuilder() {
        }

        @JsonProperty(value="groupId")
        public IBMMQServerBindingBuilder groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        @JsonProperty(value="ccdtQueueManagerName", defaultValue="*")
        public IBMMQServerBindingBuilder ccdtQueueManagerName(@Nullable String ccdtQueueManagerName) {
            this.ccdtQueueManagerName$value = ccdtQueueManagerName;
            this.ccdtQueueManagerName$set = true;
            return this;
        }

        @JsonProperty(value="cipherSpec", defaultValue="ANY")
        public IBMMQServerBindingBuilder cipherSpec(@Nullable String cipherSpec) {
            this.cipherSpec$value = cipherSpec;
            this.cipherSpec$set = true;
            return this;
        }

        @JsonProperty(value="multiEndpointServer", defaultValue="false")
        public IBMMQServerBindingBuilder multiEndpointServer(Boolean multiEndpointServer) {
            this.multiEndpointServer$value = multiEndpointServer;
            this.multiEndpointServer$set = true;
            return this;
        }

        @JsonProperty(value="heartBeatInterval", defaultValue="300")
        public IBMMQServerBindingBuilder heartBeatInterval(int heartBeatInterval) {
            this.heartBeatInterval$value = heartBeatInterval;
            this.heartBeatInterval$set = true;
            return this;
        }

        public IBMMQServerBinding build() {
            String ccdtQueueManagerName$value = this.ccdtQueueManagerName$value;
            if (!this.ccdtQueueManagerName$set) {
                ccdtQueueManagerName$value = IBMMQServerBinding.$default$ccdtQueueManagerName();
            }
            String cipherSpec$value = this.cipherSpec$value;
            if (!this.cipherSpec$set) {
                cipherSpec$value = IBMMQServerBinding.$default$cipherSpec();
            }
            Boolean multiEndpointServer$value = this.multiEndpointServer$value;
            if (!this.multiEndpointServer$set) {
                multiEndpointServer$value = IBMMQServerBinding.$default$multiEndpointServer();
            }
            int heartBeatInterval$value = this.heartBeatInterval$value;
            if (!this.heartBeatInterval$set) {
                heartBeatInterval$value = IBMMQServerBinding.$default$heartBeatInterval();
            }
            return new IBMMQServerBinding(this.groupId, ccdtQueueManagerName$value, cipherSpec$value, multiEndpointServer$value, heartBeatInterval$value);
        }

        public String toString() {
            return "IBMMQServerBinding.IBMMQServerBindingBuilder(groupId=" + this.groupId + ", ccdtQueueManagerName$value=" + this.ccdtQueueManagerName$value + ", cipherSpec$value=" + this.cipherSpec$value + ", multiEndpointServer$value=" + this.multiEndpointServer$value + ", heartBeatInterval$value=" + this.heartBeatInterval$value + ")";
        }
    }
}

