/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.asyncapi.security.v2.oauth2.flow;

import com.asyncapi.schemas.asyncapi.security.v2.oauth2.flow.OAuthFlow;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthorizationCodeOAuthFlow
extends OAuthFlow {
    @NotNull
    private String authorizationUrl = "";
    @NotNull
    private String tokenUrl = "";

    public AuthorizationCodeOAuthFlow(@Nullable String refreshUrl, @NotNull Map<String, String> scopes, @NotNull String authorizationUrl, @NotNull String tokenUrl) {
        super(refreshUrl, scopes);
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
    }

    public static AuthorizationCodeOAuthFlowBuilder authorizationCodeBuilder() {
        return new AuthorizationCodeOAuthFlowBuilder();
    }

    @NotNull
    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    @NotNull
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setAuthorizationUrl(@NotNull String authorizationUrl) {
        if (authorizationUrl == null) {
            throw new NullPointerException("authorizationUrl is marked non-null but is null");
        }
        this.authorizationUrl = authorizationUrl;
    }

    public void setTokenUrl(@NotNull String tokenUrl) {
        if (tokenUrl == null) {
            throw new NullPointerException("tokenUrl is marked non-null but is null");
        }
        this.tokenUrl = tokenUrl;
    }

    @Override
    public String toString() {
        return "AuthorizationCodeOAuthFlow(authorizationUrl=" + this.getAuthorizationUrl() + ", tokenUrl=" + this.getTokenUrl() + ")";
    }

    public AuthorizationCodeOAuthFlow() {
    }

    public AuthorizationCodeOAuthFlow(@NotNull String authorizationUrl, @NotNull String tokenUrl) {
        if (authorizationUrl == null) {
            throw new NullPointerException("authorizationUrl is marked non-null but is null");
        }
        if (tokenUrl == null) {
            throw new NullPointerException("tokenUrl is marked non-null but is null");
        }
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizationCodeOAuthFlow)) {
            return false;
        }
        AuthorizationCodeOAuthFlow other = (AuthorizationCodeOAuthFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$authorizationUrl = this.getAuthorizationUrl();
        String other$authorizationUrl = other.getAuthorizationUrl();
        if (this$authorizationUrl == null ? other$authorizationUrl != null : !this$authorizationUrl.equals(other$authorizationUrl)) {
            return false;
        }
        String this$tokenUrl = this.getTokenUrl();
        String other$tokenUrl = other.getTokenUrl();
        return !(this$tokenUrl == null ? other$tokenUrl != null : !this$tokenUrl.equals(other$tokenUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AuthorizationCodeOAuthFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $authorizationUrl = this.getAuthorizationUrl();
        result = result * 59 + ($authorizationUrl == null ? 43 : $authorizationUrl.hashCode());
        String $tokenUrl = this.getTokenUrl();
        result = result * 59 + ($tokenUrl == null ? 43 : $tokenUrl.hashCode());
        return result;
    }

    public static class AuthorizationCodeOAuthFlowBuilder {
        private String refreshUrl;
        private Map<String, String> scopes;
        private String authorizationUrl;
        private String tokenUrl;

        AuthorizationCodeOAuthFlowBuilder() {
        }

        public AuthorizationCodeOAuthFlowBuilder refreshUrl(@Nullable String refreshUrl) {
            this.refreshUrl = refreshUrl;
            return this;
        }

        public AuthorizationCodeOAuthFlowBuilder scopes(@NotNull Map<String, String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public AuthorizationCodeOAuthFlowBuilder authorizationUrl(@NotNull String authorizationUrl) {
            if (authorizationUrl == null) {
                throw new NullPointerException("authorizationUrl is marked non-null but is null");
            }
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public AuthorizationCodeOAuthFlowBuilder tokenUrl(@NotNull String tokenUrl) {
            if (tokenUrl == null) {
                throw new NullPointerException("tokenUrl is marked non-null but is null");
            }
            this.tokenUrl = tokenUrl;
            return this;
        }

        public AuthorizationCodeOAuthFlow build() {
            return new AuthorizationCodeOAuthFlow(this.refreshUrl, this.scopes, this.authorizationUrl, this.tokenUrl);
        }

        public String toString() {
            return "AuthorizationCodeOAuthFlow.AuthorizationCodeOAuthFlowBuilder(refreshUrl=" + this.refreshUrl + ", scopes=" + this.scopes + ", authorizationUrl=" + this.authorizationUrl + ", tokenUrl=" + this.tokenUrl + ")";
        }
    }
}

