/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.asyncapi.security.v2.oauth2.flow;

import com.asyncapi.schemas.asyncapi.security.v2.oauth2.flow.OAuthFlow;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientCredentialsOAuthFlow
extends OAuthFlow {
    @NotNull
    private String tokenUrl = "";

    public ClientCredentialsOAuthFlow(@Nullable String refreshUrl, @NotNull Map<String, String> scopes, @NotNull String tokenUrl) {
        super(refreshUrl, scopes);
        this.tokenUrl = tokenUrl;
    }

    public static ClientCredentialsOAuthFlowBuilder clientCredentialsBuilder() {
        return new ClientCredentialsOAuthFlowBuilder();
    }

    @NotNull
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(@NotNull String tokenUrl) {
        if (tokenUrl == null) {
            throw new NullPointerException("tokenUrl is marked non-null but is null");
        }
        this.tokenUrl = tokenUrl;
    }

    @Override
    public String toString() {
        return "ClientCredentialsOAuthFlow(tokenUrl=" + this.getTokenUrl() + ")";
    }

    public ClientCredentialsOAuthFlow() {
    }

    public ClientCredentialsOAuthFlow(@NotNull String tokenUrl) {
        if (tokenUrl == null) {
            throw new NullPointerException("tokenUrl is marked non-null but is null");
        }
        this.tokenUrl = tokenUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCredentialsOAuthFlow)) {
            return false;
        }
        ClientCredentialsOAuthFlow other = (ClientCredentialsOAuthFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tokenUrl = this.getTokenUrl();
        String other$tokenUrl = other.getTokenUrl();
        return !(this$tokenUrl == null ? other$tokenUrl != null : !this$tokenUrl.equals(other$tokenUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClientCredentialsOAuthFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tokenUrl = this.getTokenUrl();
        result = result * 59 + ($tokenUrl == null ? 43 : $tokenUrl.hashCode());
        return result;
    }

    public static class ClientCredentialsOAuthFlowBuilder {
        private String refreshUrl;
        private Map<String, String> scopes;
        private String tokenUrl;

        ClientCredentialsOAuthFlowBuilder() {
        }

        public ClientCredentialsOAuthFlowBuilder refreshUrl(@Nullable String refreshUrl) {
            this.refreshUrl = refreshUrl;
            return this;
        }

        public ClientCredentialsOAuthFlowBuilder scopes(@NotNull Map<String, String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public ClientCredentialsOAuthFlowBuilder tokenUrl(@NotNull String tokenUrl) {
            if (tokenUrl == null) {
                throw new NullPointerException("tokenUrl is marked non-null but is null");
            }
            this.tokenUrl = tokenUrl;
            return this;
        }

        public ClientCredentialsOAuthFlow build() {
            return new ClientCredentialsOAuthFlow(this.refreshUrl, this.scopes, this.tokenUrl);
        }

        public String toString() {
            return "ClientCredentialsOAuthFlow.ClientCredentialsOAuthFlowBuilder(refreshUrl=" + this.refreshUrl + ", scopes=" + this.scopes + ", tokenUrl=" + this.tokenUrl + ")";
        }
    }
}

