/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2._6_0.jackson.model.channel.message;

import com.asyncapi.bindings.MessageBindingsDeserializer;
import com.asyncapi.schemas.asyncapi.AsyncAPISchema;
import com.asyncapi.schemas.asyncapi.ExtendableObject;
import com.asyncapi.schemas.asyncapi.Reference;
import com.asyncapi.schemas.avro.v1._9_0.AvroSchema;
import com.asyncapi.schemas.json.JsonSchema;
import com.asyncapi.schemas.openapi.v3._0_0.OpenAPISchema;
import com.asyncapi.v2._6_0.jackson.model.channel.message.MessageCorrelationIdDeserializer;
import com.asyncapi.v2._6_0.jackson.model.channel.message.MessageHeadersDeserializer;
import com.asyncapi.v2._6_0.jackson.model.channel.message.MessageTraitsDeserializer;
import com.asyncapi.v2._6_0.model.ExternalDocumentation;
import com.asyncapi.v2._6_0.model.Tag;
import com.asyncapi.v2._6_0.model.channel.message.Message;
import com.asyncapi.v2._6_0.model.channel.message.MessageExample;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MessageDeserializer
extends JsonDeserializer<Message> {
    private static final List<String> propertiesToIgnore = Arrays.asList("messageId", "headers", "payload", "correlationId", "schemaFormat", "contentType", "name", "title", "summary", "description", "tags", "externalDocs", "bindings", "tags", "examples", "traits");

    private String string(JsonNode node, ObjectCodec objectCodec) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            String string = (String)jsonParser.readValueAs(String.class);
            return string;
        }
    }

    private Object headers(JsonNode node, ObjectCodec objectCodec, DeserializationContext deserializationContext) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            MessageHeadersDeserializer deserializer = new MessageHeadersDeserializer();
            Object object = deserializer.deserialize(jsonParser, deserializationContext);
            return object;
        }
    }

    private Object correlationId(JsonNode node, ObjectCodec objectCodec, DeserializationContext deserializationContext) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            MessageCorrelationIdDeserializer deserializer = new MessageCorrelationIdDeserializer();
            Object object = deserializer.deserialize(jsonParser, deserializationContext);
            return object;
        }
    }

    private List<Tag> tags(JsonNode node, ObjectCodec objectCodec) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            List list = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<Tag>>(){});
            return list;
        }
    }

    private ExternalDocumentation externalDocs(JsonNode node, ObjectCodec objectCodec) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            ExternalDocumentation externalDocumentation = (ExternalDocumentation)jsonParser.readValueAs(ExternalDocumentation.class);
            return externalDocumentation;
        }
    }

    private Map<String, Object> bindings(JsonNode node, ObjectCodec objectCodec, DeserializationContext deserializationContext) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            MessageBindingsDeserializer deserializer = new MessageBindingsDeserializer();
            Object object = deserializer.deserialize(jsonParser, deserializationContext);
            return object;
        }
    }

    private List<MessageExample> examples(JsonNode node, ObjectCodec objectCodec) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            List list = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<MessageExample>>(){});
            return list;
        }
    }

    private List<Object> traits(JsonNode node, ObjectCodec objectCodec, DeserializationContext deserializationContext) throws IOException {
        if (node == null) {
            return null;
        }
        try (JsonParser jsonParser = node.traverse(objectCodec);){
            MessageTraitsDeserializer deserializer = new MessageTraitsDeserializer();
            Object object = deserializer.deserialize(jsonParser, deserializationContext);
            return object;
        }
    }

    private Object payload(JsonNode messageNode, ObjectCodec objectCodec) throws IOException {
        JsonNode payloadNode = messageNode.get("payload");
        if (payloadNode == null) {
            return null;
        }
        try (JsonParser jsonParser = payloadNode.traverse(objectCodec);){
            if (payloadNode.properties().size() == 1 && payloadNode.get("$ref") != null) {
                Object object = jsonParser.readValueAs(Reference.class);
                return object;
            }
            JsonNode schemaFormatNode = messageNode.findValue("schemaFormat");
            if (schemaFormatNode == null) {
                Object object = jsonParser.readValueAs(AsyncAPISchema.class);
                return object;
            }
            Class messageToDeserializeTo = AsyncAPISchema.class;
            switch (schemaFormatNode.textValue()) {
                case "application/schema+json;version=draft-07": 
                case "application/schema+yaml;version=draft-07": {
                    messageToDeserializeTo = JsonSchema.class;
                    break;
                }
                case "application/vnd.oai.openapi;version=3.0.0": 
                case "application/vnd.oai.openapi+json;version=3.0.0": 
                case "application/vnd.oai.openapi+yaml;version=3.0.0": 
                case "application/vnd.oai.openapi;version=3.0.1": 
                case "application/vnd.oai.openapi+json;version=3.0.1": 
                case "application/vnd.oai.openapi+yaml;version=3.0.1": 
                case "application/vnd.oai.openapi;version=3.0.2": 
                case "application/vnd.oai.openapi+json;version=3.0.2": 
                case "application/vnd.oai.openapi+yaml;version=3.0.2": 
                case "application/vnd.oai.openapi;version=3.0.3": 
                case "application/vnd.oai.openapi+json;version=3.0.3": 
                case "application/vnd.oai.openapi+yaml;version=3.0.3": {
                    messageToDeserializeTo = OpenAPISchema.class;
                    break;
                }
                case "application/vnd.apache.avro;version=1.9.0": 
                case "application/vnd.apache.avro+json;version=1.9.0": 
                case "application/vnd.apache.avro+yaml;version=1.9.0": 
                case "application/vnd.apache.avro;version=1.9.1": 
                case "application/vnd.apache.avro+json;version=1.9.1": 
                case "application/vnd.apache.avro+yaml;version=1.9.1": 
                case "application/vnd.apache.avro;version=1.9.2": 
                case "application/vnd.apache.avro+json;version=1.9.2": 
                case "application/vnd.apache.avro+yaml;version=1.9.2": 
                case "application/vnd.apache.avro;version=1.10.0": 
                case "application/vnd.apache.avro+json;version=1.10.0": 
                case "application/vnd.apache.avro+yaml;version=1.10.0": 
                case "application/vnd.apache.avro;version=1.10.1": 
                case "application/vnd.apache.avro+json;version=1.10.1": 
                case "application/vnd.apache.avro+yaml;version=1.10.1": 
                case "application/vnd.apache.avro;version=1.10.2": 
                case "application/vnd.apache.avro+json;version=1.10.2": 
                case "application/vnd.apache.avro+yaml;version=1.10.2": 
                case "application/vnd.apache.avro;version=1.11.0": 
                case "application/vnd.apache.avro+json;version=1.11.0": 
                case "application/vnd.apache.avro+yaml;version=1.11.0": 
                case "application/vnd.apache.avro;version=1.11.1": 
                case "application/vnd.apache.avro+json;version=1.11.1": 
                case "application/vnd.apache.avro+yaml;version=1.11.1": {
                    messageToDeserializeTo = AvroSchema.class;
                }
            }
            Object object = jsonParser.readValueAs(messageToDeserializeTo);
            return object;
        }
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            JsonNodeType nodeType = jsonNode.getNodeType();
            switch (nodeType) {
                case ARRAY: {
                    List<Object> list = this.readAsList((ArrayNode)jsonNode, objectCodec);
                    return list;
                }
                case BOOLEAN: {
                    Boolean bl = jsonNode.asBoolean();
                    return bl;
                }
                case NUMBER: {
                    Object object = jsonParser.readValueAs(Number.class);
                    return object;
                }
                case OBJECT: {
                    Object object = jsonParser.readValueAs(Object.class);
                    return object;
                }
                case STRING: {
                    Object object = jsonParser.readValueAs(String.class);
                    return object;
                }
                case BINARY: 
                case POJO: 
                case MISSING: 
                case NULL: {
                    Object var5_11 = null;
                    return var5_11;
                }
            }
            Object var5_12 = null;
            return var5_12;
        }
    }

    private List<Object> readAsList(ArrayNode arrayNode, ObjectCodec objectCodec) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonNode childNode : arrayNode) {
            list.add(this.chooseKnownPojo(childNode, objectCodec));
        }
        return list;
    }

    private Map<String, Object> extensionFields(JsonNode messageNode, ObjectCodec objectCodec) throws IOException {
        if (messageNode == null) {
            return null;
        }
        HashMap<String, Object> extensionFields = new HashMap<String, Object>();
        List unknownProperties = messageNode.properties().stream().filter(property -> !propertiesToIgnore.contains(property.getKey())).collect(Collectors.toList());
        for (Map.Entry property2 : unknownProperties) {
            if (ExtendableObject.extensionPropertyNamePattern.matcher((CharSequence)property2.getKey()).matches()) {
                extensionFields.put((String)property2.getKey(), this.chooseKnownPojo((JsonNode)property2.getValue(), objectCodec));
                continue;
            }
            throw new JsonMappingException(String.format("\"%s\" is not valid extension property (through reference chain: com.asyncapi.v2._6_0.model.channel.message.Message[\"%s\"])", property2.getKey(), property2.getKey()));
        }
        if (extensionFields.isEmpty()) {
            return null;
        }
        return extensionFields;
    }

    public Message deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        ObjectCodec objectCodec = jsonParser.getCodec();
        JsonNode messageNode = (JsonNode)objectCodec.readTree(jsonParser);
        Message message = Message.builder().messageId(this.string(messageNode.get("messageId"), objectCodec)).headers(this.headers(messageNode.get("headers"), objectCodec, deserializationContext)).payload(this.payload(messageNode, objectCodec)).correlationId(this.correlationId(messageNode.get("correlationId"), objectCodec, deserializationContext)).schemaFormat(this.string(messageNode.get("schemaFormat"), objectCodec)).contentType(this.string(messageNode.get("contentType"), objectCodec)).name(this.string(messageNode.get("name"), objectCodec)).title(this.string(messageNode.get("title"), objectCodec)).summary(this.string(messageNode.get("summary"), objectCodec)).description(this.string(messageNode.get("description"), objectCodec)).tags(this.tags(messageNode.get("tags"), objectCodec)).externalDocs(this.externalDocs(messageNode.get("externalDocs"), objectCodec)).bindings(this.bindings(messageNode.get("bindings"), objectCodec, deserializationContext)).examples(this.examples(messageNode.get("examples"), objectCodec)).traits(this.traits(messageNode.get("traits"), objectCodec, deserializationContext)).build();
        message.setExtensionFields(this.extensionFields(messageNode, objectCodec));
        return message;
    }
}

