/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3._0_0.jackson.model.channel.message;

import com.asyncapi.schemas.asyncapi.AsyncAPISchema;
import com.asyncapi.schemas.asyncapi.Reference;
import com.asyncapi.schemas.asyncapi.multiformat.MultiFormatSchema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class MessageHeadersDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        try {
            return this.chooseKnownPojo(node, objectCodec);
        }
        catch (UnrecognizedPropertyException unrecognizedPropertyException) {
            return this.readAsObject(node, objectCodec);
        }
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        JsonNode ref = jsonNode.get("$ref");
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            if (this.isMultiFormatSchema(jsonNode)) {
                Object object = jsonParser.readValueAs(MultiFormatSchema.class);
                return object;
            }
            if (ref != null) {
                Object object = jsonParser.readValueAs(Reference.class);
                return object;
            }
            Object object = jsonParser.readValueAs(AsyncAPISchema.class);
            return object;
        }
    }

    private Object readAsObject(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            Object object = jsonParser.readValueAs(AsyncAPISchema.class);
            return object;
        }
    }

    private boolean isMultiFormatSchema(@NotNull JsonNode jsonNode) {
        JsonNode schemaFormat = jsonNode.get("schemaFormat");
        JsonNode schema = jsonNode.get("schema");
        return schemaFormat != null && schema != null;
    }
}

