/**
 * This module provides bindings to describe protocol-specific things:
 * <ul>
 *     <li>Channel</li>
 *     <li>Message</li>
 *     <li>Operation</li>
 *     <li>Server</li>
 * </ul>
 *
 * <br>
 * A "binding" (or "protocol binding") is a mechanism to define protocol-specific information.
 * <p>
 * Therefore, a protocol binding <b>MUST</b> define protocol-specific information only.
 *
 * @see <a href="https://github.com/asyncapi/bindings/tree/master">AsyncAPI Bindings</a>
 * @see <a href="https://www.asyncapi.com/docs/reference/specification/v3.0.0#channelBindingsObject">AsyncAPI Channel Bindings</a>
 * @see <a href="https://www.asyncapi.com/docs/reference/specification/v3.0.0#messageBindingsObject">AsyncAPI Message Bindings</a>
 * @see <a href="https://www.asyncapi.com/docs/reference/specification/v3.0.0#operationBindingsObject">AsyncAPI Operation Bindings</a>
 * @see <a href="https://www.asyncapi.com/docs/reference/specification/v3.0.0#serverBindingsObject">AsyncAPI Server Bindings</a>
 * @author Pavel Bodiachevskii
 * @since 1.0.0-RC2
 */
package com.asyncapi.bindings;