/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.amqp.v0._3_0.channel.queue;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.Size;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes AMQP 0-9-1 channel queue properties.")
public class AMQPChannelQueueProperties {
    @Size(max=255, message="Queue name must not exceed 255 characters long.")
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the queue. It MUST NOT exceed 255 characters long.")
    @Nullable
    private @Size(max=255, message="Queue name must not exceed 255 characters long.") @Nullable String name;
    @JsonProperty(value="durable")
    @JsonPropertyDescription(value="Whether the queue should survive broker restarts or not.")
    @Nullable
    private Boolean durable;
    @JsonProperty(value="exclusive")
    @JsonPropertyDescription(value="Whether the queue should be used only by one connection or not.")
    @Nullable
    private Boolean exclusive;
    @JsonProperty(value="autoDelete")
    @JsonPropertyDescription(value="Whether the queue should be deleted when the last consumer unsubscribes.")
    @Nullable
    private Boolean autoDelete;
    @JsonProperty(value="vhost", defaultValue="/")
    @JsonPropertyDescription(value="The virtual host of the queue. Defaults to /.")
    @Nullable
    private String vhost;

    private static String $default$vhost() {
        return "/";
    }

    public static AMQPChannelQueuePropertiesBuilder builder() {
        return new AMQPChannelQueuePropertiesBuilder();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getDurable() {
        return this.durable;
    }

    @Nullable
    public Boolean getExclusive() {
        return this.exclusive;
    }

    @Nullable
    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    @Nullable
    public String getVhost() {
        return this.vhost;
    }

    @JsonProperty(value="name")
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @JsonProperty(value="durable")
    public void setDurable(@Nullable Boolean durable) {
        this.durable = durable;
    }

    @JsonProperty(value="exclusive")
    public void setExclusive(@Nullable Boolean exclusive) {
        this.exclusive = exclusive;
    }

    @JsonProperty(value="autoDelete")
    public void setAutoDelete(@Nullable Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    @JsonProperty(value="vhost", defaultValue="/")
    public void setVhost(@Nullable String vhost) {
        this.vhost = vhost;
    }

    public String toString() {
        return "AMQPChannelQueueProperties(name=" + this.getName() + ", durable=" + this.getDurable() + ", exclusive=" + this.getExclusive() + ", autoDelete=" + this.getAutoDelete() + ", vhost=" + this.getVhost() + ")";
    }

    public AMQPChannelQueueProperties() {
        this.vhost = AMQPChannelQueueProperties.$default$vhost();
    }

    public AMQPChannelQueueProperties(@Nullable String name, @Nullable Boolean durable, @Nullable Boolean exclusive, @Nullable Boolean autoDelete, @Nullable String vhost) {
        this.name = name;
        this.durable = durable;
        this.exclusive = exclusive;
        this.autoDelete = autoDelete;
        this.vhost = vhost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AMQPChannelQueueProperties)) {
            return false;
        }
        AMQPChannelQueueProperties other = (AMQPChannelQueueProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$durable = this.getDurable();
        Boolean other$durable = other.getDurable();
        if (this$durable == null ? other$durable != null : !((Object)this$durable).equals(other$durable)) {
            return false;
        }
        Boolean this$exclusive = this.getExclusive();
        Boolean other$exclusive = other.getExclusive();
        if (this$exclusive == null ? other$exclusive != null : !((Object)this$exclusive).equals(other$exclusive)) {
            return false;
        }
        Boolean this$autoDelete = this.getAutoDelete();
        Boolean other$autoDelete = other.getAutoDelete();
        if (this$autoDelete == null ? other$autoDelete != null : !((Object)this$autoDelete).equals(other$autoDelete)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$vhost = this.getVhost();
        String other$vhost = other.getVhost();
        return !(this$vhost == null ? other$vhost != null : !this$vhost.equals(other$vhost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AMQPChannelQueueProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $durable = this.getDurable();
        result = result * 59 + ($durable == null ? 43 : ((Object)$durable).hashCode());
        Boolean $exclusive = this.getExclusive();
        result = result * 59 + ($exclusive == null ? 43 : ((Object)$exclusive).hashCode());
        Boolean $autoDelete = this.getAutoDelete();
        result = result * 59 + ($autoDelete == null ? 43 : ((Object)$autoDelete).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $vhost = this.getVhost();
        result = result * 59 + ($vhost == null ? 43 : $vhost.hashCode());
        return result;
    }

    public static class AMQPChannelQueuePropertiesBuilder {
        private String name;
        private Boolean durable;
        private Boolean exclusive;
        private Boolean autoDelete;
        private boolean vhost$set;
        private String vhost$value;

        AMQPChannelQueuePropertiesBuilder() {
        }

        @JsonProperty(value="name")
        public AMQPChannelQueuePropertiesBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="durable")
        public AMQPChannelQueuePropertiesBuilder durable(@Nullable Boolean durable) {
            this.durable = durable;
            return this;
        }

        @JsonProperty(value="exclusive")
        public AMQPChannelQueuePropertiesBuilder exclusive(@Nullable Boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        @JsonProperty(value="autoDelete")
        public AMQPChannelQueuePropertiesBuilder autoDelete(@Nullable Boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        @JsonProperty(value="vhost", defaultValue="/")
        public AMQPChannelQueuePropertiesBuilder vhost(@Nullable String vhost) {
            this.vhost$value = vhost;
            this.vhost$set = true;
            return this;
        }

        public AMQPChannelQueueProperties build() {
            String vhost$value = this.vhost$value;
            if (!this.vhost$set) {
                vhost$value = AMQPChannelQueueProperties.$default$vhost();
            }
            return new AMQPChannelQueueProperties(this.name, this.durable, this.exclusive, this.autoDelete, vhost$value);
        }

        public String toString() {
            return "AMQPChannelQueueProperties.AMQPChannelQueuePropertiesBuilder(name=" + this.name + ", durable=" + this.durable + ", exclusive=" + this.exclusive + ", autoDelete=" + this.autoDelete + ", vhost$value=" + this.vhost$value + ")";
        }
    }
}

