/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.ibmmq.v0._1_0.channel;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes IBM MQ channel queue properties.")
public class IBMMQChannelQueueProperties {
    @NotNull
    @Size(max=48, message="Name of the IBM MQ queue must be less or equals to 48")
    @JsonProperty(value="objectName")
    @JsonPropertyDescription(value="Defines the name of the IBM MQ queue associated with the channel.")
    @org.jetbrains.annotations.NotNull
    private @NotNull @Size(max=48, message="Name of the IBM MQ queue must be less or equals to 48") @org.jetbrains.annotations.NotNull String objectName;
    @JsonProperty(value="isPartitioned", defaultValue="false")
    @JsonPropertyDescription(value="Defines if the queue is a cluster queue and therefore partitioned. If 'true', a binding option MAY be specified when accessing the queue. More information on binding options can be found on this page in the IBM MQ Knowledge Center.")
    @Nullable
    private Boolean isPartitioned;
    @JsonProperty(value="exclusive", defaultValue="false")
    @JsonPropertyDescription(value="Specifies if it is recommended to open the queue exclusively.")
    @Nullable
    private Boolean exclusive;

    private static String $default$objectName() {
        return "";
    }

    private static Boolean $default$isPartitioned() {
        return false;
    }

    private static Boolean $default$exclusive() {
        return false;
    }

    public static IBMMQChannelQueuePropertiesBuilder builder() {
        return new IBMMQChannelQueuePropertiesBuilder();
    }

    @org.jetbrains.annotations.NotNull
    public String getObjectName() {
        return this.objectName;
    }

    @Nullable
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @Nullable
    public Boolean getExclusive() {
        return this.exclusive;
    }

    @JsonProperty(value="objectName")
    public void setObjectName(@org.jetbrains.annotations.NotNull String objectName) {
        if (objectName == null) {
            throw new NullPointerException("objectName is marked non-null but is null");
        }
        this.objectName = objectName;
    }

    @JsonProperty(value="isPartitioned", defaultValue="false")
    public void setIsPartitioned(@Nullable Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    @JsonProperty(value="exclusive", defaultValue="false")
    public void setExclusive(@Nullable Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public String toString() {
        return "IBMMQChannelQueueProperties(objectName=" + this.getObjectName() + ", isPartitioned=" + this.getIsPartitioned() + ", exclusive=" + this.getExclusive() + ")";
    }

    public IBMMQChannelQueueProperties() {
        this.objectName = IBMMQChannelQueueProperties.$default$objectName();
        this.isPartitioned = IBMMQChannelQueueProperties.$default$isPartitioned();
        this.exclusive = IBMMQChannelQueueProperties.$default$exclusive();
    }

    public IBMMQChannelQueueProperties(@org.jetbrains.annotations.NotNull String objectName, @Nullable Boolean isPartitioned, @Nullable Boolean exclusive) {
        if (objectName == null) {
            throw new NullPointerException("objectName is marked non-null but is null");
        }
        this.objectName = objectName;
        this.isPartitioned = isPartitioned;
        this.exclusive = exclusive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IBMMQChannelQueueProperties)) {
            return false;
        }
        IBMMQChannelQueueProperties other = (IBMMQChannelQueueProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isPartitioned = this.getIsPartitioned();
        Boolean other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !((Object)this$isPartitioned).equals(other$isPartitioned)) {
            return false;
        }
        Boolean this$exclusive = this.getExclusive();
        Boolean other$exclusive = other.getExclusive();
        if (this$exclusive == null ? other$exclusive != null : !((Object)this$exclusive).equals(other$exclusive)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        return !(this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IBMMQChannelQueueProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isPartitioned = this.getIsPartitioned();
        result = result * 59 + ($isPartitioned == null ? 43 : ((Object)$isPartitioned).hashCode());
        Boolean $exclusive = this.getExclusive();
        result = result * 59 + ($exclusive == null ? 43 : ((Object)$exclusive).hashCode());
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        return result;
    }

    public static class IBMMQChannelQueuePropertiesBuilder {
        private boolean objectName$set;
        private String objectName$value;
        private boolean isPartitioned$set;
        private Boolean isPartitioned$value;
        private boolean exclusive$set;
        private Boolean exclusive$value;

        IBMMQChannelQueuePropertiesBuilder() {
        }

        @JsonProperty(value="objectName")
        public IBMMQChannelQueuePropertiesBuilder objectName(@org.jetbrains.annotations.NotNull String objectName) {
            if (objectName == null) {
                throw new NullPointerException("objectName is marked non-null but is null");
            }
            this.objectName$value = objectName;
            this.objectName$set = true;
            return this;
        }

        @JsonProperty(value="isPartitioned", defaultValue="false")
        public IBMMQChannelQueuePropertiesBuilder isPartitioned(@Nullable Boolean isPartitioned) {
            this.isPartitioned$value = isPartitioned;
            this.isPartitioned$set = true;
            return this;
        }

        @JsonProperty(value="exclusive", defaultValue="false")
        public IBMMQChannelQueuePropertiesBuilder exclusive(@Nullable Boolean exclusive) {
            this.exclusive$value = exclusive;
            this.exclusive$set = true;
            return this;
        }

        public IBMMQChannelQueueProperties build() {
            String objectName$value = this.objectName$value;
            if (!this.objectName$set) {
                objectName$value = IBMMQChannelQueueProperties.$default$objectName();
            }
            Boolean isPartitioned$value = this.isPartitioned$value;
            if (!this.isPartitioned$set) {
                isPartitioned$value = IBMMQChannelQueueProperties.$default$isPartitioned();
            }
            Boolean exclusive$value = this.exclusive$value;
            if (!this.exclusive$set) {
                exclusive$value = IBMMQChannelQueueProperties.$default$exclusive();
            }
            return new IBMMQChannelQueueProperties(objectName$value, isPartitioned$value, exclusive$value);
        }

        public String toString() {
            return "IBMMQChannelQueueProperties.IBMMQChannelQueuePropertiesBuilder(objectName$value=" + this.objectName$value + ", isPartitioned$value=" + this.isPartitioned$value + ", exclusive$value=" + this.exclusive$value + ")";
        }
    }
}

