/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.bindings.solace.v0._2_0.operation;

import com.asyncapi.bindings.solace.v0._2_0.operation.queue.SolaceOperationQueue;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes Solace destination.")
public class SolaceOperationDestination {
    @JsonProperty(value="destinationType")
    @JsonPropertyDescription(value="'queue' or 'topic'. If the type is queue, then the subscriber can bind to the queue, which in turn will subscribe to the topic as represented by the channel name or to the provided topicSubscriptions.")
    @Nullable
    private Type destinationType;
    @JsonProperty(value="deliveryMode", defaultValue="persistent")
    @JsonPropertyDescription(value="'direct' or 'persistent'. This determines the quality of service for publishing messages as documented at https://docs.solace.com/Get-Started/Core-Concepts-Message-Delivery-Modes.htm. Default is 'persistent'.")
    @Nullable
    private DeliveryMode deliveryMode;
    @JsonProperty(value="queue")
    @JsonPropertyDescription(value="Solace queue destination details.")
    @Nullable
    private SolaceOperationQueue queue;
    @JsonProperty(value="topicSubscriptions")
    @JsonPropertyDescription(value="The list of topics that the client subscribes to.")
    @Nullable
    private List<String> topicSubscriptions;

    private static DeliveryMode $default$deliveryMode() {
        return DeliveryMode.PERSISTENT;
    }

    public static SolaceOperationDestinationBuilder builder() {
        return new SolaceOperationDestinationBuilder();
    }

    @Nullable
    public Type getDestinationType() {
        return this.destinationType;
    }

    @Nullable
    public DeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    @Nullable
    public SolaceOperationQueue getQueue() {
        return this.queue;
    }

    @Nullable
    public List<String> getTopicSubscriptions() {
        return this.topicSubscriptions;
    }

    @JsonProperty(value="destinationType")
    public void setDestinationType(@Nullable Type destinationType) {
        this.destinationType = destinationType;
    }

    @JsonProperty(value="deliveryMode", defaultValue="persistent")
    public void setDeliveryMode(@Nullable DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @JsonProperty(value="queue")
    public void setQueue(@Nullable SolaceOperationQueue queue) {
        this.queue = queue;
    }

    @JsonProperty(value="topicSubscriptions")
    public void setTopicSubscriptions(@Nullable List<String> topicSubscriptions) {
        this.topicSubscriptions = topicSubscriptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolaceOperationDestination)) {
            return false;
        }
        SolaceOperationDestination other = (SolaceOperationDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$destinationType = this.getDestinationType();
        Type other$destinationType = other.getDestinationType();
        if (this$destinationType == null ? other$destinationType != null : !((Object)((Object)this$destinationType)).equals((Object)other$destinationType)) {
            return false;
        }
        DeliveryMode this$deliveryMode = this.getDeliveryMode();
        DeliveryMode other$deliveryMode = other.getDeliveryMode();
        if (this$deliveryMode == null ? other$deliveryMode != null : !((Object)((Object)this$deliveryMode)).equals((Object)other$deliveryMode)) {
            return false;
        }
        SolaceOperationQueue this$queue = this.getQueue();
        SolaceOperationQueue other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !((Object)this$queue).equals(other$queue)) {
            return false;
        }
        List<String> this$topicSubscriptions = this.getTopicSubscriptions();
        List<String> other$topicSubscriptions = other.getTopicSubscriptions();
        return !(this$topicSubscriptions == null ? other$topicSubscriptions != null : !((Object)this$topicSubscriptions).equals(other$topicSubscriptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolaceOperationDestination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $destinationType = this.getDestinationType();
        result = result * 59 + ($destinationType == null ? 43 : ((Object)((Object)$destinationType)).hashCode());
        DeliveryMode $deliveryMode = this.getDeliveryMode();
        result = result * 59 + ($deliveryMode == null ? 43 : ((Object)((Object)$deliveryMode)).hashCode());
        SolaceOperationQueue $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : ((Object)$queue).hashCode());
        List<String> $topicSubscriptions = this.getTopicSubscriptions();
        result = result * 59 + ($topicSubscriptions == null ? 43 : ((Object)$topicSubscriptions).hashCode());
        return result;
    }

    public String toString() {
        return "SolaceOperationDestination(destinationType=" + (Object)((Object)this.getDestinationType()) + ", deliveryMode=" + (Object)((Object)this.getDeliveryMode()) + ", queue=" + this.getQueue() + ", topicSubscriptions=" + this.getTopicSubscriptions() + ")";
    }

    public SolaceOperationDestination() {
        this.deliveryMode = SolaceOperationDestination.$default$deliveryMode();
    }

    public SolaceOperationDestination(@Nullable Type destinationType, @Nullable DeliveryMode deliveryMode, @Nullable SolaceOperationQueue queue, @Nullable List<String> topicSubscriptions) {
        this.destinationType = destinationType;
        this.deliveryMode = deliveryMode;
        this.queue = queue;
        this.topicSubscriptions = topicSubscriptions;
    }

    public static enum DeliveryMode {
        DIRECT,
        PERSISTENT;

    }

    public static class SolaceOperationDestinationBuilder {
        private Type destinationType;
        private boolean deliveryMode$set;
        private DeliveryMode deliveryMode$value;
        private SolaceOperationQueue queue;
        private List<String> topicSubscriptions;

        SolaceOperationDestinationBuilder() {
        }

        @JsonProperty(value="destinationType")
        public SolaceOperationDestinationBuilder destinationType(@Nullable Type destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @JsonProperty(value="deliveryMode", defaultValue="persistent")
        public SolaceOperationDestinationBuilder deliveryMode(@Nullable DeliveryMode deliveryMode) {
            this.deliveryMode$value = deliveryMode;
            this.deliveryMode$set = true;
            return this;
        }

        @JsonProperty(value="queue")
        public SolaceOperationDestinationBuilder queue(@Nullable SolaceOperationQueue queue) {
            this.queue = queue;
            return this;
        }

        @JsonProperty(value="topicSubscriptions")
        public SolaceOperationDestinationBuilder topicSubscriptions(@Nullable List<String> topicSubscriptions) {
            this.topicSubscriptions = topicSubscriptions;
            return this;
        }

        public SolaceOperationDestination build() {
            DeliveryMode deliveryMode$value = this.deliveryMode$value;
            if (!this.deliveryMode$set) {
                deliveryMode$value = SolaceOperationDestination.$default$deliveryMode();
            }
            return new SolaceOperationDestination(this.destinationType, deliveryMode$value, this.queue, this.topicSubscriptions);
        }

        public String toString() {
            return "SolaceOperationDestination.SolaceOperationDestinationBuilder(destinationType=" + (Object)((Object)this.destinationType) + ", deliveryMode$value=" + (Object)((Object)this.deliveryMode$value) + ", queue=" + this.queue + ", topicSubscriptions=" + this.topicSubscriptions + ")";
        }
    }

    public static enum Type {
        QUEUE,
        TOPIC;

    }
}

