/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.asyncapi.security.v2.http;

import com.asyncapi.schemas.asyncapi.security.v2.SecurityScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpApiKeySecurityScheme
extends SecurityScheme {
    @NotNull
    private String name = "";
    @Nullable
    private ApiKeyLocation in;

    public HttpApiKeySecurityScheme(@Nullable String description, @NotNull String name, @Nullable ApiKeyLocation in) {
        super(SecurityScheme.Type.HTTP_API_KEY, description);
        this.name = name;
        this.in = in;
    }

    public static HttpApiKeySecuritySchemeBuilder httpApiKeyBuilder() {
        return new HttpApiKeySecuritySchemeBuilder();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public ApiKeyLocation getIn() {
        return this.in;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setIn(@Nullable ApiKeyLocation in) {
        this.in = in;
    }

    @Override
    public String toString() {
        return "HttpApiKeySecurityScheme(name=" + this.getName() + ", in=" + (Object)((Object)this.getIn()) + ")";
    }

    public HttpApiKeySecurityScheme() {
    }

    public HttpApiKeySecurityScheme(@NotNull String name, @Nullable ApiKeyLocation in) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.in = in;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpApiKeySecurityScheme)) {
            return false;
        }
        HttpApiKeySecurityScheme other = (HttpApiKeySecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ApiKeyLocation this$in = this.getIn();
        ApiKeyLocation other$in = other.getIn();
        return !(this$in == null ? other$in != null : !((Object)((Object)this$in)).equals((Object)other$in));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpApiKeySecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ApiKeyLocation $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)((Object)$in)).hashCode());
        return result;
    }

    public static enum ApiKeyLocation {
        QUERY,
        HEADER,
        COOKIE;

    }

    public static class HttpApiKeySecuritySchemeBuilder {
        private String description;
        private String name;
        private ApiKeyLocation in;

        HttpApiKeySecuritySchemeBuilder() {
        }

        public HttpApiKeySecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public HttpApiKeySecuritySchemeBuilder name(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public HttpApiKeySecuritySchemeBuilder in(@Nullable ApiKeyLocation in) {
            this.in = in;
            return this;
        }

        public HttpApiKeySecurityScheme build() {
            return new HttpApiKeySecurityScheme(this.description, this.name, this.in);
        }

        public String toString() {
            return "HttpApiKeySecurityScheme.HttpApiKeySecuritySchemeBuilder(description=" + this.description + ", name=" + this.name + ", in=" + (Object)((Object)this.in) + ")";
        }
    }
}

