/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.asyncapi.security.v2.oauth2;

import com.asyncapi.schemas.asyncapi.security.v2.SecurityScheme;
import com.asyncapi.schemas.asyncapi.security.v2.oauth2.OAuthFlows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuth2SecurityScheme
extends SecurityScheme {
    @NotNull
    private OAuthFlows flows = new OAuthFlows();

    public OAuth2SecurityScheme(@Nullable String description, @NotNull OAuthFlows flows) {
        super(SecurityScheme.Type.OAUTH2, description);
        this.flows = flows;
    }

    public static OAuth2SecuritySchemeBuilder oauth2Builder() {
        return new OAuth2SecuritySchemeBuilder();
    }

    @NotNull
    public OAuthFlows getFlows() {
        return this.flows;
    }

    public void setFlows(@NotNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    @Override
    public String toString() {
        return "OAuth2SecurityScheme(flows=" + this.getFlows() + ")";
    }

    public OAuth2SecurityScheme() {
    }

    public OAuth2SecurityScheme(@NotNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2SecurityScheme)) {
            return false;
        }
        OAuth2SecurityScheme other = (OAuth2SecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthFlows this$flows = this.getFlows();
        OAuthFlows other$flows = other.getFlows();
        return !(this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2SecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OAuthFlows $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        return result;
    }

    public static class OAuth2SecuritySchemeBuilder {
        private String description;
        private OAuthFlows flows;

        OAuth2SecuritySchemeBuilder() {
        }

        public OAuth2SecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OAuth2SecuritySchemeBuilder flows(@NotNull OAuthFlows flows) {
            if (flows == null) {
                throw new NullPointerException("flows is marked non-null but is null");
            }
            this.flows = flows;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme(this.description, this.flows);
        }

        public String toString() {
            return "OAuth2SecurityScheme.OAuth2SecuritySchemeBuilder(description=" + this.description + ", flows=" + this.flows + ")";
        }
    }
}

