/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.avro.v1._9_0;

import com.asyncapi.schemas.avro.v1._9_0.AvroSchemaMetadata;
import com.asyncapi.schemas.avro.v1._9_0.serde.AvroTypeDeserializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvroSchemaRecordField
extends AvroSchemaMetadata {
    @JsonProperty(value="type")
    @JsonDeserialize(using=AvroTypeDeserializer.class)
    @NotNull
    private Object type;
    @JsonProperty(value="name")
    @NotNull
    private String name = "";
    @JsonProperty(value="order")
    @Nullable
    private Order order = Order.ASCENDING;
    @JsonProperty(value="doc")
    @Nullable
    private String doc;
    @JsonProperty(value="aliases")
    private @Nullable List<@NotNull String> aliases;
    @JsonProperty(value="default")
    @Nullable
    private Object defaultValue;

    public AvroSchemaRecordField() {
        this.type = "record";
    }

    public AvroSchemaRecordField(@NotNull Object type, @NotNull String name, @Nullable Order order, @Nullable String doc, @Nullable List<@NotNull String> aliases, @Nullable Object defaultValue, @Nullable Map<String, Object> metadata) {
        this.type = type;
        this.name = name;
        this.order = order == null ? Order.ASCENDING : order;
        this.doc = doc;
        this.aliases = aliases;
        this.defaultValue = defaultValue;
        this.metadata = metadata;
    }

    public AvroSchemaRecordField(@NotNull Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.order = builder.order;
        this.doc = builder.doc;
        this.aliases = builder.aliases;
        this.defaultValue = builder.defaultValue;
        this.metadata = builder.metadata;
    }

    @NotNull
    public Order getOrder() {
        if (this.order == null) {
            this.setOrder(Order.ASCENDING);
        }
        return this.order;
    }

    public void setOrder(@NotNull Order order) {
        this.order = order;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Object getType() {
        return this.type;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDoc() {
        return this.doc;
    }

    public @Nullable List<@NotNull String> getAliases() {
        return this.aliases;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="type")
    @JsonDeserialize(using=AvroTypeDeserializer.class)
    public void setType(@NotNull Object type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="name")
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="doc")
    public void setDoc(@Nullable String doc) {
        this.doc = doc;
    }

    @JsonProperty(value="aliases")
    public void setAliases(@Nullable List<@NotNull String> aliases) {
        this.aliases = aliases;
    }

    @JsonProperty(value="default")
    public void setDefaultValue(@Nullable Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String toString() {
        return "AvroSchemaRecordField(type=" + this.getType() + ", name=" + this.getName() + ", order=" + (Object)((Object)this.getOrder()) + ", doc=" + this.getDoc() + ", aliases=" + this.getAliases() + ", defaultValue=" + this.getDefaultValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AvroSchemaRecordField)) {
            return false;
        }
        AvroSchemaRecordField other = (AvroSchemaRecordField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$type = this.getType();
        Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Order this$order = this.getOrder();
        Order other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order)) {
            return false;
        }
        String this$doc = this.getDoc();
        String other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !this$doc.equals(other$doc)) {
            return false;
        }
        List<String> this$aliases = this.getAliases();
        List<String> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AvroSchemaRecordField;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Order $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
        String $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : $doc.hashCode());
        List<String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public static enum Order {
        ASCENDING,
        DESCENDING,
        IGNORE;

    }

    public static class Builder {
        @NotNull
        private Object type = "record";
        @NotNull
        private String name = "";
        @Nullable
        private Order order = Order.ASCENDING;
        @Nullable
        private String doc;
        private @Nullable List<@NotNull String> aliases;
        @Nullable
        private Object defaultValue;
        @Nullable
        private Map<String, Object> metadata;

        @NotNull
        public Builder type(@NotNull Object type) {
            this.type = type;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public Builder order(@Nullable Order order) {
            this.order = order == null ? Order.ASCENDING : order;
            return this;
        }

        @NotNull
        public Builder doc(@Nullable String doc) {
            this.doc = doc;
            return this;
        }

        @NotNull
        public Builder aliases(@Nullable List<@NotNull String> aliases) {
            this.aliases = aliases;
            return this;
        }

        @NotNull
        public Builder defaultValue(@Nullable Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @NotNull
        public Builder metadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public AvroSchemaRecordField build() {
            return new AvroSchemaRecordField(this);
        }
    }
}

