/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.schemas.xml;

import com.asyncapi.schemas.asyncapi.Reference;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Objects;

public class XMLSchemaDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        return this.chooseKnownPojo(node, objectCodec);
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            JsonNodeType nodeType = jsonNode.getNodeType();
            if (Objects.requireNonNull(nodeType) == JsonNodeType.STRING) {
                Object object = jsonParser.readValueAs(String.class);
                return object;
            }
            if (Objects.requireNonNull(nodeType) == JsonNodeType.OBJECT) {
                if (this.isRefNode(jsonNode)) {
                    Object object = jsonParser.readValueAs(Reference.class);
                    return object;
                }
                Object var5_8 = null;
                return var5_8;
            }
            Object var5_9 = null;
            return var5_9;
        }
    }

    private boolean isRefNode(JsonNode jsonNode) {
        return jsonNode.size() == 1 && jsonNode.has("$ref");
    }
}

