/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ListOfReferencesOrObjectsDeserializer<ObjectType>
extends JsonDeserializer<List<Object>> {
    public abstract Class<ObjectType> objectTypeClass();

    public abstract Class<?> referenceClass();

    public List<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        ArrayList<Object> traits = new ArrayList<Object>();
        node.forEach(traitsValue -> {
            try {
                traits.add(this.chooseKnownPojo((JsonNode)traitsValue, objectCodec));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return traits;
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        JsonNode ref = jsonNode.get("$ref");
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            if (ref != null) {
                Object object = jsonParser.readValueAs(this.referenceClass());
                return object;
            }
            Object object = jsonParser.readValueAs(this.objectTypeClass());
            return object;
        }
    }
}

