/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2._6_0.jackson.model.channel.operation;

import com.asyncapi.schemas.asyncapi.Reference;
import com.asyncapi.v2._6_0.model.channel.message.Message;
import com.asyncapi.v2._6_0.model.channel.message.OneOfMessages;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class OperationMessageDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        return this.chooseKnownPojo(node, objectCodec);
    }

    private Object chooseKnownPojo(JsonNode message, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = message.traverse(objectCodec);){
            if (message.get("oneOf") != null) {
                Object object = jsonParser.readValueAs(OneOfMessages.class);
                return object;
            }
            if (message.get("$ref") != null) {
                Object object = jsonParser.readValueAs(Reference.class);
                return object;
            }
            Object object = jsonParser.readValueAs(Message.class);
            return object;
        }
    }
}

