/*
 * Decompiled with CFR 0.152.
 */
package com.atatctech.packages.cache;

import com.atatctech.packages.log.Log;

public class Cache<T> {
    protected Log.Time expire = Log.Time.FUTURE;
    protected Log.Time.TimePeriod refreshInterval;
    private final T object;

    public Cache(T object) {
        this.object = object;
    }

    public Cache(T object, Log.Time.TimePeriod ttl) {
        this.object = object;
        this.setTTL(ttl);
    }

    public Cache(T object, Log.Time expire) {
        this.object = object;
        this.setExpire(expire);
    }

    public void setExpire(Log.Time expire) {
        this.expire = expire;
    }

    public void setTTL(Log.Time.TimePeriod ttl) {
        this.setExpire(new Log.Time().forward(ttl));
    }

    public void setRefreshInterval(Log.Time.TimePeriod refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Log.Time.TimePeriod getRefreshInterval() {
        return this.refreshInterval;
    }

    public Log.Time getExpire() {
        return this.expire;
    }

    public T getObject() {
        return this.object;
    }

    public T getCache() {
        return this.getObject();
    }

    public Class<?> getObjectClass() {
        return this.object.getClass();
    }

    public boolean hasExpired() {
        return this.expire.isPast();
    }
}

