/*
 * Decompiled with CFR 0.152.
 */
package com.atatctech.packages.cache;

import com.atatctech.packages.cache.Cache;
import com.atatctech.packages.cache.CacheKey;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class CacheContainer<T> {
    protected Map<CacheKey, Cache<T>> cacheMap = new ConcurrentHashMap<CacheKey, Cache<T>>();
    protected Filter filter = (key, value) -> false;

    public synchronized void abandonOldest(int n) {
        List<CacheKey> list = this.cacheMap.keySet().stream().sorted(Comparator.comparing(CacheKey::age)).toList().subList(0, n);
        for (CacheKey key : list) {
            this.cacheMap.remove(key);
        }
    }

    public synchronized void inspect() {
        this.cacheMap.forEach((k, v) -> {
            if (v.hasExpired() || this.filter.drop((CacheKey)k, (Cache<?>)v)) {
                this.cacheMap.remove(k);
            }
        });
    }

    public boolean containsKey(CacheKey key) {
        return this.cacheMap.containsKey(key);
    }

    public boolean containsValue(Cache<?> value) {
        return this.cacheMap.containsValue(value);
    }

    public boolean contains(CacheKey key) {
        return this.containsKey(key);
    }

    public void put(@NotNull CacheKey key, Cache<T> value) {
        this.inspect();
        key.rebirth();
        this.cacheMap.put(key, value);
    }

    public void put(Object key, Cache<T> value) {
        this.put(new CacheKey(key), value);
    }

    public void put(Object key, Object value) {
        this.put((Object)new CacheKey(key), (Object)new Cache<Object>(value));
    }

    public Cache<T> get(CacheKey key) {
        this.inspect();
        return this.cacheMap.get(key);
    }

    public T getCache(CacheKey key) {
        return this.get(key).getCache();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @FunctionalInterface
    public static interface Filter {
        public boolean drop(CacheKey var1, Cache<?> var2);
    }
}

