/*
 * Decompiled with CFR 0.152.
 */
package com.atatctech.packages.concurrent.rl;

import com.atatctech.packages.concurrent.rl.exception.MaxCapacity;
import com.atatctech.packages.concurrent.rl.exception.MaxRate;

public class Bucket {
    protected final long capacity;
    protected long amountLeft;

    public Bucket(long capacity, long initAmount) {
        this.capacity = capacity;
        this.amountLeft = initAmount;
    }

    public Bucket(long capacity) {
        this.capacity = capacity;
        this.amountLeft = 0L;
    }

    public long getAmountLeft() {
        return this.amountLeft;
    }

    protected synchronized void add(long amount) {
        this.amountLeft = Math.max(0L, Math.min(this.amountLeft + amount, this.capacity));
    }

    public void safeReplenish(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("`amount` must be a positive integer.");
        }
        this.add(amount);
    }

    public boolean replenish(long amount) {
        if (this.getAmountLeft() + amount > this.capacity) {
            return false;
        }
        this.safeReplenish(amount);
        return true;
    }

    public void tryReplenish(long amount) throws MaxCapacity {
        if (!this.replenish(amount)) {
            throw new MaxCapacity();
        }
    }

    public void safePour(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("`amount` must be a positive integer.");
        }
        this.add(-amount);
    }

    public boolean pour(long amount) {
        if (this.getAmountLeft() - amount < 0L) {
            return false;
        }
        this.safePour(amount);
        return true;
    }

    public void tryPour(long amount) throws MaxRate {
        if (!this.pour(amount)) {
            throw new MaxRate();
        }
    }
}

