/*
 * Decompiled with CFR 0.152.
 */
package com.atatctech.packages.concurrent.rl;

import com.atatctech.packages.concurrent.rl.Bucket;
import com.atatctech.packages.concurrent.rl.exception.MaxRate;
import com.atatctech.packages.log.Log;
import org.jetbrains.annotations.NotNull;

public abstract class RateLimiter {
    protected Log.Time lastReplenishment = new Log.Time();
    protected final long unitAmount;
    protected final long interval;
    protected final Bucket bucket;

    public RateLimiter(long unitAmount, long interval) {
        this.unitAmount = unitAmount;
        this.interval = interval;
        this.bucket = new Bucket(unitAmount, unitAmount);
    }

    public RateLimiter(long unitAmount, @NotNull Log.Time.TimePeriod interval) {
        this.unitAmount = unitAmount;
        this.interval = interval.getMilliseconds();
        this.bucket = new Bucket(unitAmount, unitAmount);
    }

    protected void updateReplenishmentTime() {
        this.lastReplenishment = new Log.Time();
    }

    protected long getReplenishmentAmount() {
        return this.unitAmount * this.lastReplenishment.getDuration() / this.interval;
    }

    public void getToken() throws MaxRate {
        this.preGetToken();
        this.bucket.tryPour(1L);
        this.postGetToken();
    }

    protected void preGetToken() {
        this.bucket.safeReplenish(this.getReplenishmentAmount());
    }

    protected void postGetToken() {
        this.updateReplenishmentTime();
    }
}

