/*
 * Decompiled with CFR 0.152.
 */
package com.atatctech.packages.log;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Log {

    public static class Time {
        public static final Time FUTURE = new Time(SpecialCase.FUTURE);
        public static final Time PAST = new Time(SpecialCase.PAST);
        protected final long baseTime;

        public Time() {
            this.baseTime = System.currentTimeMillis();
        }

        public Time(long baseTime) {
            if (baseTime < 0L) {
                throw new IllegalArgumentException("`baseTime` must be a positive integer.");
            }
            this.baseTime = baseTime;
        }

        @Contract(pure=true)
        public Time(@NotNull SpecialCase specialCase) {
            this.baseTime = switch (specialCase) {
                default -> throw new IncompatibleClassChangeError();
                case SpecialCase.FUTURE -> Long.MAX_VALUE;
                case SpecialCase.PAST -> Long.MIN_VALUE;
            };
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public static Time parseString(String baseTime, String format) {
            SimpleDateFormat form = new SimpleDateFormat(format);
            try {
                return new Time(form.parse(baseTime).getTime());
            }
            catch (ParseException e) {
                return new Time();
            }
        }

        @Contract(value="_ -> new")
        @NotNull
        public static Time parseString(String baseTime) {
            return Time.parseString(baseTime, "yyyy-MM-dd HH:mm:ss");
        }

        @Contract(pure=true)
        protected static int getUnitCoefficients(@NotNull Unit unit) {
            return switch (unit) {
                default -> throw new IncompatibleClassChangeError();
                case Unit.Millisecond -> 1;
                case Unit.Second -> 1000;
                case Unit.Minute -> 60000;
                case Unit.Hour -> 3600000;
                case Unit.Day -> 86400000;
                case Unit.Week -> 604800000;
            };
        }

        public static long convert(Unit origin, Unit result, long value) {
            return value * (long)Time.getUnitCoefficients(origin) / (long)Time.getUnitCoefficients(result);
        }

        public static long calculateDuration(@NotNull Runnable action, Unit unit) {
            long baseTime = System.currentTimeMillis();
            action.run();
            long endTime = System.currentTimeMillis();
            return (endTime - baseTime) / (long)Time.getUnitCoefficients(unit);
        }

        public static long calculateDuration(@NotNull Time time1, @NotNull Time time2, Unit unit) {
            return Time.convert(Unit.Millisecond, unit, Math.abs(time1.getBaseTime() - time2.getBaseTime()));
        }

        public static boolean theSame(@NotNull Time time1, @NotNull Time time2, Unit unit) {
            return Time.convert(Unit.Millisecond, unit, time1.getBaseTime()) == Time.convert(Unit.Millisecond, unit, time2.getBaseTime());
        }

        public boolean isFuture() {
            return this.getBaseTime() > System.currentTimeMillis();
        }

        public boolean isCurrent() {
            return this.getBaseTime() == System.currentTimeMillis();
        }

        public boolean isPast() {
            return this.getBaseTime() < System.currentTimeMillis();
        }

        public Time forward(@NotNull TimePeriod gap) {
            return new Time(this.getBaseTime() + gap.getMilliseconds());
        }

        public Time backward(@NotNull TimePeriod gap) {
            return new Time(this.getBaseTime() - gap.getMilliseconds());
        }

        public String getStamp() {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return formatter.format(new Date(this.getBaseTime()));
        }

        public String getStamp(String format) {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            return formatter.format(new Date(this.getBaseTime()));
        }

        public long getDuration(Unit unit) {
            long duration = Math.abs(System.currentTimeMillis() - this.getBaseTime());
            return duration / (long)Time.getUnitCoefficients(unit);
        }

        public long getDuration() {
            return Math.abs(System.currentTimeMillis() - this.getBaseTime());
        }

        public Milliseconds getDurationAsGap() {
            return new Milliseconds(this.getDuration());
        }

        public long getDuration(@NotNull Time time, Unit unit) {
            long duration = Math.abs(time.getBaseTime() - this.getBaseTime());
            return duration / (long)Time.getUnitCoefficients(unit);
        }

        public TimePeriod getDurationAsGap(Time time, Unit unit) {
            return TimePeriod.fromUnit(this.getDuration(time, unit), unit);
        }

        public long getBaseTime() {
            return this.baseTime;
        }

        public static enum SpecialCase {
            FUTURE,
            PAST;

        }

        public static enum Unit {
            Week,
            Day,
            Hour,
            Minute,
            Second,
            Millisecond;

        }

        public static class TimePeriod {
            protected final long milliseconds;

            public static TimePeriod fromUnit(long n, @NotNull Unit unit) {
                return switch (unit) {
                    default -> throw new IncompatibleClassChangeError();
                    case Unit.Week -> new Weeks(n);
                    case Unit.Day -> new Days(n);
                    case Unit.Hour -> new Hours(n);
                    case Unit.Minute -> new Minutes(n);
                    case Unit.Second -> new Seconds(n);
                    case Unit.Millisecond -> new Milliseconds(n);
                };
            }

            public TimePeriod(long milliseconds) {
                this.milliseconds = milliseconds;
            }

            public long getMilliseconds() {
                return this.milliseconds;
            }
        }

        public static class Milliseconds
        extends TimePeriod {
            public Milliseconds(long milliseconds) {
                super(milliseconds);
            }
        }

        public static class Weeks
        extends Days {
            public Weeks(long weeks) {
                super(weeks * 7L);
            }
        }

        public static class Days
        extends Hours {
            public Days(long days) {
                super(days * 24L);
            }
        }

        public static class Hours
        extends Minutes {
            public Hours(long hours) {
                super(hours * 60L);
            }
        }

        public static class Minutes
        extends Seconds {
            public Minutes(long minutes) {
                super(minutes * 60L);
            }
        }

        public static class Seconds
        extends Milliseconds {
            public Seconds(long seconds) {
                super(seconds * 1000L);
            }
        }
    }
}

