/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.api.ansi;

import com.athaydes.osgiaas.api.ansi.AnsiColor;
import com.athaydes.osgiaas.api.ansi.AnsiModifier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Ansi {
    public static final Pattern ANSI_PATTERN = Pattern.compile("(\\u001B)?\\[\\d*m");

    static String simpleAnsiEscape(int code) {
        return "\u001b[" + code + "m";
    }

    public static String foreColorEscape(int b) {
        if (-1 < b && b < 256) {
            return "\u001b[38;5;" + b + "m";
        }
        throw new IllegalArgumentException("code not in the range 0..255");
    }

    public static String backColorEscape(int b) {
        if (-1 < b && b < 256) {
            return "\u001b[48;5;" + b + "m";
        }
        throw new IllegalArgumentException("code not in the range 0..255");
    }

    public static String applyColor(String text, AnsiColor color) {
        return Ansi.applyAnsi(text, color, new AnsiModifier[0]);
    }

    public static String applyForeColor(String text, int colorByte) {
        return Ansi.asString(Ansi.join(Ansi.foreColorEscape(colorByte), text));
    }

    public static String applyBackColor(String text, int colorByte) {
        return Ansi.asString(Ansi.join(Ansi.backColorEscape(colorByte), text));
    }

    public static String applyAnsi(String text, @Nullable AnsiColor color, AnsiModifier ... modifiers) {
        String[] modifierEscapers = (String[])Stream.of(modifiers).map(AnsiModifier::toString).toArray(String[]::new);
        return Ansi.asString(Ansi.join(color == null ? null : color.toString(), Ansi.join(text, modifierEscapers)));
    }

    public static String applyAnsi(String text, @Nullable String firstEscapeSequence, @Nullable String secondEscapeSequence, String ... escapeSequences) {
        if (escapeSequences == null) {
            escapeSequences = new String[]{};
        }
        String[] parts = new String[escapeSequences.length + 3];
        parts[0] = firstEscapeSequence;
        parts[1] = secondEscapeSequence;
        System.arraycopy(escapeSequences, 0, parts, 2, escapeSequences.length);
        parts[parts.length - 1] = text;
        return Ansi.asString(parts);
    }

    public static String applyAnsi(String text, @Nullable String escapeSequence) {
        return Ansi.applyAnsi(text, escapeSequence, null, new String[0]);
    }

    private static String asString(String ... parts) {
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part == null) continue;
            builder.append(part);
        }
        builder.append((Object)AnsiColor.RESET);
        return builder.toString();
    }

    private static String[] join(@Nullable String object, String ... others) {
        if (others == null || others.length == 0) {
            return new String[]{object};
        }
        String[] result = new String[others.length + 1];
        result[0] = object;
        System.arraycopy(others, 0, result, 1, others.length);
        return result;
    }
}

