/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.api.ansi;

import com.athaydes.osgiaas.api.ansi.Ansi;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AnsiColor {
    RESET(0),
    FOREGROUND_DEFAULT(39),
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    PURPLE(35),
    CYAN(36),
    LIGHT_GRAY(37),
    DARK_GRAY(90),
    LIGHT_RED(91),
    LIGHT_GREEN(92),
    LIGHT_YELLOW(93),
    LIGHT_BLUE(94),
    LIGHT_PURPLE(95),
    LIGHT_CYAN(96),
    WHITE(97),
    BKG_DEFAULT(49),
    BKG_BLACK(40),
    BKG_RED(41),
    BKG_GREEN(42),
    BKG_YELLOW(43),
    BKG_BLUE(44),
    BKG_PURPLE(45),
    BKG_CYAN(46),
    BKG_LIGHT_GRAY(47),
    BKG_DARK_GRAY(100),
    BKG_LIGHT_RED(101),
    BKG_LIGHT_GREEN(102),
    BKG_LIGHT_YELLOW(103),
    BKG_LIGHT_BLUE(104),
    BKG_LIGHT_PURPLE(105),
    BKG_LIGHT_CYAN(106),
    BKG_WHITE(107);

    public static final Pattern NUMBER_PATTERN;
    public static final AnsiColor DEFAULT_BG;
    public static final String BKG_PREFIX = "BKG_";
    private final int code;

    private AnsiColor(int code) {
        this.code = code;
    }

    public String toString() {
        return Ansi.simpleAnsiEscape(this.code);
    }

    public static boolean isColor(String text) {
        String option1 = text.toUpperCase();
        String option2 = BKG_PREFIX + option1;
        return Stream.of(AnsiColor.values()).anyMatch(it -> it.name().equals(option1) || it.name().equals(option2)) || AnsiColor.isValidCode(text);
    }

    static boolean isValidCode(String text) {
        if (NUMBER_PATTERN.matcher(text).matches()) {
            int b = Integer.parseInt(text);
            return -1 < b && b < 256;
        }
        return false;
    }

    public static String backColorEscapeCode(String color) {
        if (AnsiColor.isValidCode(color)) {
            return Ansi.backColorEscape(Integer.parseInt(color));
        }
        if (!(color = color.toUpperCase()).startsWith(BKG_PREFIX)) {
            color = BKG_PREFIX + color;
        }
        return AnsiColor.valueOf(color).toString();
    }

    public static String foreColorEscapeCode(String color) {
        if (AnsiColor.isValidCode(color)) {
            return Ansi.foreColorEscape(Integer.parseInt(color));
        }
        if (AnsiColor.colorNames().contains(color.toLowerCase())) {
            return AnsiColor.valueOf(color.toUpperCase()).toString();
        }
        throw new IllegalArgumentException("not a valid color: " + color);
    }

    public static Set<String> colorNames() {
        return Arrays.stream(AnsiColor.values()).map(Enum::name).filter(it -> !it.startsWith(BKG_PREFIX)).map(String::toLowerCase).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static {
        NUMBER_PATTERN = Pattern.compile("\\d{1,3}");
        DEFAULT_BG = BKG_YELLOW;
    }
}

