/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.api.env;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ProcessRunner {
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public int run(List<String> commands, File workingDirectory, PrintStream out, PrintStream err) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(commands).directory(workingDirectory).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
        CountDownLatch latch = new CountDownLatch(2);
        this.consume(process.getInputStream(), out, err, latch);
        this.consume(process.getErrorStream(), err, err, latch);
        int exitValue = process.waitFor();
        boolean noTimeout = latch.await(5L, TimeUnit.SECONDS);
        if (!noTimeout) {
            err.println("Process timeout! Killing it forcefully");
            process.destroyForcibly();
        }
        return exitValue;
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }

    private void consume(InputStream stream, PrintStream writer, PrintStream err, CountDownLatch latch) {
        this.executorService.submit(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8), 1024);
            try {
                String nextLine;
                while ((nextLine = reader.readLine()) != null) {
                    writer.println(nextLine);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(err);
            }
            finally {
                latch.countDown();
            }
        });
    }
}

