/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.api.service;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class DynamicServiceHelper {
    public static <T> void with(AtomicReference<T> reference, Consumer<T> consumer) {
        DynamicServiceHelper.with(reference, consumer, () -> {});
    }

    public static <T> void with(AtomicReference<T> reference, Consumer<T> consumer, Runnable onUnavailable) {
        T instance = reference.get();
        if (instance != null) {
            consumer.accept(instance);
        } else {
            onUnavailable.run();
        }
    }

    public static <T, R> R let(AtomicReference<T> reference, Function<T, R> consumer, Supplier<R> defaultSupplier) {
        AtomicReference resultRef = new AtomicReference();
        DynamicServiceHelper.with(reference, value -> resultRef.set(consumer.apply(value)), () -> resultRef.set(defaultSupplier.get()));
        return (R)resultRef.get();
    }
}

