/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.api.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public abstract class HasManyServices<ServiceType> {
    private final AtomicReference<List<ServiceType>> services = new AtomicReference(Collections.emptyList());

    protected Comparator<ServiceType> getComparator() {
        return (a, b) -> 0;
    }

    protected void addService(ServiceType service) {
        this.services.updateAndGet(old -> {
            ArrayList<Object> update = new ArrayList<Object>((Collection<Object>)old);
            update.add(service);
            Collections.sort(update, this.getComparator());
            return update;
        });
    }

    protected void removeService(ServiceType service) {
        this.services.updateAndGet(old -> {
            ArrayList update = new ArrayList(old);
            update.remove(service);
            return update;
        });
    }

    protected List<ServiceType> getServices() {
        return this.services.get();
    }
}

