/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.api.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.function.Consumer;

public final class LineOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_CAPACITY = 1024;
    private final Consumer<String> onLine;
    private final LinkedList<ByteBuffer> buffers = new LinkedList();
    private final AutoCloseable closeWhenDone;
    private final int bufferCapacity;
    private ByteBuffer buffer;

    public LineOutputStream(Consumer<String> onLine, AutoCloseable closeWhenDone) {
        this(onLine, closeWhenDone, 1024);
    }

    public LineOutputStream(Consumer<String> onLine, AutoCloseable closeWhenDone, int bufferCapacity) {
        this.onLine = onLine;
        this.closeWhenDone = closeWhenDone;
        this.bufferCapacity = bufferCapacity;
        if (bufferCapacity < 1) {
            throw new IllegalArgumentException("bufferCapacity must be greater than 0");
        }
        this.startNewByteBuffer();
    }

    private void startNewByteBuffer() {
        this.buffer = ByteBuffer.allocate(this.bufferCapacity);
        this.buffers.add(this.buffer);
    }

    private String readBuffers() {
        int totalSize = 0;
        for (int i = 0; i < this.buffers.size() - 1; ++i) {
            totalSize += this.bufferCapacity;
        }
        byte[] finalArray = new byte[totalSize += this.buffers.getLast().position()];
        int currentFirstIndex = 0;
        while (this.buffers.size() > 1) {
            ByteBuffer currentBuffer = this.buffers.removeFirst();
            currentBuffer.rewind();
            currentBuffer.get(finalArray, currentFirstIndex, this.bufferCapacity);
            currentFirstIndex += this.bufferCapacity;
        }
        this.buffer = this.buffers.getFirst();
        int bufferPosition = this.buffer.position();
        this.buffer.rewind();
        this.buffer.get(finalArray, currentFirstIndex, bufferPosition);
        this.buffer.rewind();
        return new String(finalArray, StandardCharsets.UTF_8);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10) {
            this.consumeLine();
            return;
        }
        if (this.buffer.position() >= this.bufferCapacity) {
            this.startNewByteBuffer();
        }
        this.buffer.put((byte)b);
    }

    private void consumeLine() {
        if (this.buffers.size() > 1 || this.buffer.position() > 0) {
            this.onLine.accept(this.readBuffers());
        }
    }

    @Override
    public void close() throws IOException {
        this.consumeLine();
        this.buffers.clear();
        try {
            this.closeWhenDone.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

