/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.javac;

import java.util.Collection;
import java.util.Collections;

public interface JavaSnippet {
    public String getExecutableCode();

    public Collection<String> getImports();

    public static class Builder
    implements JavaSnippet {
        private String code = "";
        private Collection<String> imports = Collections.emptyList();

        private Builder() {
        }

        public static Builder withCode(String code) {
            Builder b = new Builder();
            b.code = code;
            return b;
        }

        public Builder withImports(Collection<String> imports) {
            this.imports = imports;
            return this;
        }

        @Override
        public String getExecutableCode() {
            return this.code;
        }

        @Override
        public Collection<String> getImports() {
            return this.imports;
        }
    }
}

