/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.javac;

import com.athaydes.osgiaas.api.env.ClassLoaderContext;
import com.athaydes.osgiaas.javac.JavaSnippet;
import com.athaydes.osgiaas.javac.internal.DefaultClassLoaderContext;
import com.athaydes.osgiaas.javac.internal.SnippetClass;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasJavaCompilerService;
import java.io.PrintStream;
import java.util.Optional;
import java.util.concurrent.Callable;

public interface JavacService {
    default public PrintStream defaultWriter() {
        return System.err;
    }

    default public <T> Optional<Class<T>> compileJavaClass(ClassLoaderContext classLoaderContext, String qualifiedName, String code) {
        return this.compileJavaClass(classLoaderContext, qualifiedName, code, this.defaultWriter());
    }

    public <T> Optional<Class<T>> compileJavaClass(ClassLoaderContext var1, String var2, String var3, PrintStream var4);

    default public Optional<Callable<?>> compileJavaSnippet(String snippet) {
        return this.compileJavaSnippet(JavaSnippet.Builder.withCode(snippet), (ClassLoaderContext)DefaultClassLoaderContext.INSTANCE, this.defaultWriter());
    }

    default public Optional<Callable<?>> compileJavaSnippet(String snippet, ClassLoaderContext classLoaderContext) {
        return this.compileJavaSnippet(JavaSnippet.Builder.withCode(snippet), classLoaderContext, this.defaultWriter());
    }

    default public Optional<Callable<?>> compileJavaSnippet(String snippet, ClassLoaderContext classLoaderContext, PrintStream writer) {
        return this.compileJavaSnippet(JavaSnippet.Builder.withCode(snippet), classLoaderContext, writer);
    }

    default public Optional<Callable<?>> compileJavaSnippet(JavaSnippet snippet) {
        return this.compileJavaSnippet(snippet, (ClassLoaderContext)DefaultClassLoaderContext.INSTANCE, this.defaultWriter());
    }

    default public Optional<Callable<?>> compileJavaSnippet(JavaSnippet snippet, ClassLoaderContext classLoaderContext) {
        return this.compileJavaSnippet(snippet, classLoaderContext, this.defaultWriter());
    }

    default public Optional<Callable<?>> compileJavaSnippet(JavaSnippet snippet, ClassLoaderContext classLoaderContext, PrintStream writer) {
        SnippetClass snippetClass = SnippetClass.asCallableSnippet(snippet);
        try {
            return this.compileJavaClass(classLoaderContext, snippetClass.getClassName(), snippetClass.getCode(), writer).map(SnippetClass::uncheckedInstantiator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public String getJavaSnippetClass(JavaSnippet snippet) {
        return SnippetClass.asCallableSnippet(snippet).getCode();
    }

    public ClassLoaderContext getAugmentedClassLoaderContext(ClassLoaderContext var1);

    public static JavacService createDefault() {
        return new OsgiaasJavaCompilerService();
    }
}

