/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.javac.internal.compiler;

import com.athaydes.osgiaas.api.env.ClassLoaderContext;
import com.athaydes.osgiaas.javac.internal.CompilerUtils;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasFileObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OsgiaasClassLoader
extends ClassLoader
implements ClassLoaderContext {
    private static final Logger logger = LoggerFactory.getLogger(OsgiaasClassLoader.class);
    private final Map<String, OsgiaasFileObject> fileByClassName = new HashMap<String, OsgiaasFileObject>();
    private final Map<String, Collection<JavaFileObject>> filesByPackage = new HashMap<String, Collection<JavaFileObject>>();
    private final ClassLoaderContext classLoaderContext;

    OsgiaasClassLoader(ClassLoaderContext classLoaderContext) {
        super(classLoaderContext.getClassLoader());
        this.classLoaderContext = classLoaderContext;
    }

    Collection<JavaFileObject> filesIn(String packageName) {
        Stream<JavaFileObject> compiledClasses = this.fileByClassName.entrySet().stream().filter(entry -> CompilerUtils.packageOf((String)entry.getKey()).equals(packageName)).map(Map.Entry::getValue);
        Collection classLoaderClasses = this.filesByPackage.computeIfAbsent(packageName, this::computeClassesIn);
        return Stream.concat(compiledClasses, classLoaderClasses.stream()).collect(Collectors.toSet());
    }

    private Collection<JavaFileObject> computeClassesIn(String packageName) {
        logger.debug("Computing classes in package {}", (Object)packageName);
        return this.classLoaderContext.getClassesIn(packageName).stream().map(path -> OsgiaasClassLoader.loadBytecodeFrom(new OsgiaasFileObject(CompilerUtils.classNameFromPath(path), JavaFileObject.Kind.CLASS), this.classLoaderContext.getInputStream(path))).collect(Collectors.toList());
    }

    private static JavaFileObject loadBytecodeFrom(OsgiaasFileObject file, InputStream input) {
        byte[] buffer = new byte[4096];
        try (OutputStream out = file.openOutputStream();){
            int len;
            while ((len = input.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            logger.warn("Problem loading bytecode for {}: {}", (Object)file, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return this.classLoaderContext.getClassLoader().loadClass(name);
        }
    }

    @Override
    protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
        OsgiaasFileObject file = this.fileByClassName.get(qualifiedClassName);
        if (file != null) {
            byte[] bytes = file.getByteCode();
            return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
        }
        return super.findClass(qualifiedClassName);
    }

    void add(String qualifiedClassName, OsgiaasFileObject javaFile) {
        this.fileByClassName.put(qualifiedClassName, javaFile);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String qualifiedClassName;
        OsgiaasFileObject file;
        if (name.endsWith(".class") && (file = this.fileByClassName.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
            return new ByteArrayInputStream(file.getByteCode());
        }
        InputStream inputStream = super.getResourceAsStream(name);
        if (inputStream == null) {
            inputStream = this.classLoaderContext.getClassLoader().getResourceAsStream(name);
        }
        return inputStream;
    }

    public ClassLoader getClassLoader() {
        return this;
    }

    public Collection<String> getClassesIn(String packageName) {
        Collection classes = this.classLoaderContext.getClassesIn(packageName);
        Set<String> customClasses = this.fileByClassName.keySet();
        HashSet<String> result = new HashSet<String>(classes.size() + customClasses.size());
        result.addAll(classes);
        result.addAll(customClasses);
        return result;
    }
}

