/*
 * Decompiled with CFR 0.152.
 */
package com.athaydes.osgiaas.javac.internal.compiler;

import com.athaydes.osgiaas.javac.internal.CompilerUtils;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasClassLoader;
import com.athaydes.osgiaas.javac.internal.compiler.OsgiaasFileObject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

final class OsgiaasFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final OsgiaasClassLoader classLoader;
    private final Map<URI, JavaFileObject> fileObjectByURI = new HashMap<URI, JavaFileObject>();

    OsgiaasFileManager(JavaFileManager fileManager, OsgiaasClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileObject o = this.fileObjectByURI.get(CompilerUtils.uri(location, packageName, relativeName));
        if (o != null) {
            return o;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObject file) {
        this.fileObjectByURI.put(CompilerUtils.uri(location, packageName, relativeName), file);
    }

    void removeFile(StandardLocation location, String packageName, String relativeName) {
        this.fileObjectByURI.remove(CompilerUtils.uri(location, packageName, relativeName));
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
        OsgiaasFileObject file = new OsgiaasFileObject(qualifiedName, kind);
        this.classLoader.add(qualifiedName, file);
        return file;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
        return file instanceof OsgiaasFileObject ? file.getName() : super.inferBinaryName(loc, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            Collection<JavaFileObject> loaderClasses = this.classLoader.filesIn(packageName);
            files.addAll(loaderClasses);
            for (JavaFileObject file : this.fileObjectByURI.values()) {
                if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
        } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject file : this.fileObjectByURI.values()) {
                if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
        }
        for (JavaFileObject file : result) {
            files.add(file);
        }
        return files;
    }
}

